/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.analyzers.generic;

import com.ibm.appscan.frameworks.analyzers.generic.LangIndependentWalaUtil;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.analysis.typeInference.TypeAbstraction;
import com.ibm.wala.analysis.typeInference.TypeInference;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.CodeScanner;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.jstaint.util.SignatureUtil;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.util.ref.ReferenceCleanser;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class CodeProcessor {
    private static final Logger logger = TaintLogger.i().getLogger();
    private final IClassHierarchy cha;
    private final AnalysisCache cache;
    private final List<ICodeVisitor> visitors = new ArrayList<ICodeVisitor>();
    private static final boolean PERIODIC_WIPE_SOFT_CACHES = true;
    private static final int WIPE_SOFT_CACHE_INTERVAL = 2500;
    private static int wipeCount = 0;

    public CodeProcessor(IClassHierarchy cha, AnalysisCache cache) {
        this.cha = cha;
        this.cache = cache;
    }

    public void addVisitor(ICodeVisitor visitor) {
        assert (!this.visitors.contains(visitor));
        this.visitors.add(visitor);
    }

    public void process() {
        ReferenceCleanser.registerClassHierarchy((IClassHierarchy)this.cha);
        ReferenceCleanser.registerCache((AnalysisCache)this.cache);
        for (IClassLoader loader : this.cha.getLoaders()) {
            ArrayList<ICodeVisitor> activeVisitorsForLoader = new ArrayList<ICodeVisitor>();
            for (ICodeVisitor visitor : this.visitors) {
                if (!visitor.accepts(loader)) continue;
                activeVisitorsForLoader.add(visitor);
            }
            if (activeVisitorsForLoader.isEmpty()) continue;
            Iterator iter = loader.iterateAllClasses();
            while (iter.hasNext()) {
                IClass klass = (IClass)iter.next();
                ArrayList<ICodeVisitor> activeVisitorsForClass = new ArrayList<ICodeVisitor>();
                for (ICodeVisitor visitor : activeVisitorsForLoader) {
                    if (!visitor.accepts(klass)) continue;
                    activeVisitorsForClass.add(visitor);
                }
                if (activeVisitorsForClass.isEmpty()) continue;
                for (IMethod m : klass.getDeclaredMethods()) {
                    ArrayList<ICodeVisitor> activeVisitorsForMethod = new ArrayList<ICodeVisitor>();
                    for (ICodeVisitor visitor : activeVisitorsForClass) {
                        if (!visitor.accepts(m)) continue;
                        activeVisitorsForMethod.add(visitor);
                    }
                    if (activeVisitorsForMethod.isEmpty()) continue;
                    TypeAbstraction[] types = null;
                    ArrayList<ICodeVisitor> methodVisitors = new ArrayList<ICodeVisitor>();
                    ArrayList<ICodeVisitor> callSiteVisitors = new ArrayList<ICodeVisitor>();
                    for (ICodeVisitor visitor : activeVisitorsForMethod) {
                        if (visitor.visitsCallSites()) {
                            callSiteVisitors.add(visitor);
                            continue;
                        }
                        methodVisitors.add(visitor);
                    }
                    for (ICodeVisitor visitor : methodVisitors) {
                        IR ir = LangIndependentWalaUtil.getIR(m, this.cache);
                        if (ir == null) continue;
                        DefUse du = LangIndependentWalaUtil.getDU(ir, this.cache);
                        types = TypeInference.make((IR)ir, (boolean)false).extractAllResults();
                        visitor.visitMethod(m, ir, du, types);
                        this.wipeSoftCaches();
                    }
                    try {
                        for (CallSiteReference callSiteRef : CodeScanner.getCallSites((IMethod)m)) {
                            SSAAbstractInvokeInstruction[] calls;
                            IR ir;
                            IMethod targetMethod = this.cha.resolveMethod(callSiteRef.getDeclaredTarget());
                            CallInfo callInfo = new CallInfo(targetMethod);
                            if (targetMethod == null) continue;
                            ArrayList<ICodeVisitor> activeVisitorsForCallSite = new ArrayList<ICodeVisitor>();
                            for (ICodeVisitor visitor : callSiteVisitors) {
                                if (!visitor.accepts(m, callSiteRef, callInfo)) continue;
                                activeVisitorsForCallSite.add(visitor);
                            }
                            if (activeVisitorsForCallSite.isEmpty() || (ir = LangIndependentWalaUtil.getIR(m, this.cache)) == null) continue;
                            DefUse du = LangIndependentWalaUtil.getDU(ir, this.cache);
                            if (types == null) {
                                types = TypeInference.make((IR)ir, (boolean)false).extractAllResults();
                            }
                            for (SSAAbstractInvokeInstruction call : calls = ir.getCalls(callSiteRef)) {
                                for (ICodeVisitor visitor : activeVisitorsForCallSite) {
                                    visitor.visitCallSite(m, ir, du, types, callSiteRef, call, callInfo);
                                }
                            }
                            this.wipeSoftCaches();
                        }
                    }
                    catch (InvalidClassFileException e) {
                        logger.warn((Object)"encountered an invalid class file", (Throwable)e);
                    }
                }
            }
        }
    }

    private void wipeSoftCaches() {
        if (++wipeCount >= 2500) {
            wipeCount = 0;
            ReferenceCleanser.clearSoftCaches();
        }
    }

    private class CallInfo
    implements ICallSiteInfo {
        private final IMethod m;

        public CallInfo(IMethod m) {
            this.m = m;
        }

        @Override
        public boolean overrides(String sig) {
            IMethod queryMethod = SignatureUtil.sig2Method((String)sig, (IClassHierarchy)CodeProcessor.this.cha, (Language)CodeProcessor.this.cha.getLoaders()[0].getLanguage());
            return queryMethod != null && CodeProcessor.this.cha.isAssignableFrom(queryMethod.getDeclaringClass(), this.m.getDeclaringClass()) && queryMethod.getSelector().equals((Object)this.m.getSelector());
        }
    }

    public static interface ICodeVisitor {
        public boolean accepts(IClassLoader var1);

        public boolean accepts(IClass var1);

        public boolean accepts(IMethod var1);

        public boolean visitsCallSites();

        public boolean accepts(IMethod var1, CallSiteReference var2, ICallSiteInfo var3);

        public void visitCallSite(IMethod var1, IR var2, DefUse var3, TypeAbstraction[] var4, CallSiteReference var5, SSAAbstractInvokeInstruction var6, ICallSiteInfo var7);

        public void visitMethod(IMethod var1, IR var2, DefUse var3, TypeAbstraction[] var4);
    }

    public static interface ICallSiteInfo {
        public boolean overrides(String var1);
    }
}

