/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.analyzers.generic;

import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.JarFileEntry;
import com.ibm.wala.classLoader.ModuleEntry;
import com.ibm.wala.classLoader.ShrikeClass;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.impl.Everywhere;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.util.warnings.Warnings;
import org.apache.log4j.Logger;

public class LangIndependentWalaUtil {
    public static DefUse getDU(IR ir, AnalysisCache cache) {
        return cache.getSSACache().findOrCreateDU(ir, (Context)Everywhere.EVERYWHERE);
    }

    public static void logAllWarningsAndClear() {
        Logger logger = TaintLogger.i().getLogger();
        logger.debug((Object)"WALA warnings:");
        logger.debug((Object)Warnings.asString());
        Warnings.clear();
    }

    public static String getEnclosingArchiveName(IClass declaringClass) {
        ModuleEntry moduleEntry;
        if (declaringClass instanceof ShrikeClass && (moduleEntry = ((ShrikeClass)declaringClass).getModuleEntry()) instanceof JarFileEntry) {
            return ((JarFileEntry)moduleEntry).getJarFile().getName();
        }
        return null;
    }

    public static IR getIR(IMethod method, AnalysisCache cache) {
        try {
            return cache.getIR(method);
        }
        catch (Exception e) {
            LangIndependentWalaUtil.generateIRFailureMessage(method, e);
            return null;
        }
    }

    private static void generateIRFailureMessage(IMethod method, Throwable t) {
        String message = "WALA error while generating IR for method " + method;
        String jarFileName = LangIndependentWalaUtil.getEnclosingArchiveName(method.getDeclaringClass());
        if (jarFileName != null) {
            message = message + ", jar file " + jarFileName;
        }
        Logger logger = TaintLogger.i().getLogger();
        logger.info((Object)message);
    }
}

