/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.vdb.cache;

import com.ibm.appscan.common.Language;
import com.ibm.appscan.vdb.exception.VDBGeneralException;
import com.ibm.appscan.vdb.misc.VDBConstants;
import com.ibm.appscan.vdb.provider.method.MethodProvider;
import com.ibm.appscan.vdb.provider.method.audit.AuditProvider;
import java.util.Date;

public class AuditCache {
    private AuditProvider m_audit_provider;
    private Language.LANGUAGE m_lang;

    public AuditCache(Language.LANGUAGE lang) {
        this.m_lang = lang;
    }

    public AuditProvider getAuditProvider() {
        if (this.m_audit_provider == null) {
            this.m_audit_provider = new AuditProvider(this.m_lang);
        }
        return this.m_audit_provider;
    }

    public String getAuditDates() throws VDBGeneralException {
        StringBuffer str = new StringBuffer();
        for (String date : this.getAuditProvider().getStringAuditDates()) {
            str.append(date);
            str.append("#");
        }
        if (str.length() > 0) {
            str.deleteCharAt(str.length() - 1);
        }
        return str.toString();
    }

    public MethodProvider getBeforeProvider(String date) {
        return this.getAuditProvider().getBeforeProvider(date);
    }

    public MethodProvider getAfterProvider(String date) {
        return this.getAuditProvider().getAfterProvider(date);
    }

    public MethodProvider getBeforeProvider(Date d) {
        return this.getBeforeProvider(VDBConstants.AUDIT_DATE_FORMAT.format(d));
    }

    public MethodProvider getAfterProvider(Date d) {
        return this.getAfterProvider(VDBConstants.AUDIT_DATE_FORMAT.format(d));
    }
}

