/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.vdb.method;

import com.ibm.appscan.assessment.model.Assessment;
import com.ibm.appscan.assessment.model.Finding;
import com.ibm.appscan.assessment.model.Taint;
import com.ibm.appscan.common.Language;
import com.ibm.appscan.vdb.data.Vdb;
import com.ibm.appscan.vdb.exception.BadMarkupException;
import com.ibm.appscan.vdb.exception.VDBException;
import com.ibm.appscan.vdb.exception.VDBGeneralException;
import com.ibm.appscan.vdb.method.Method;
import com.ibm.appscan.vdb.method.MethodCacheListener;
import com.ibm.appscan.vdb.method.NonClassFunction;
import com.ibm.appscan.vdb.provider.VdbProvider;
import com.ibm.appscan.vdb.provider.method.MethodProvider;
import java.util.HashMap;

public class MethodCache {
    private HashMap<String, Method> m_methods = new HashMap(10000);
    private HashMap<String, MethodCacheListener> m_listeners = new HashMap();

    public synchronized Method getMethod(String signature, Language.LANGUAGE lang) {
        Method m = this.m_methods.get(signature);
        if (m != null) {
            return m;
        }
        try {
            Vdb v = VdbProvider.getMethod(lang, signature);
            if (v != null && v.getMethods().size() > 0) {
                m = v.getMethods().get(0);
                this.addMethod(m);
                return m;
            }
        }
        catch (VDBException e1) {
            return this.getBlankMethod(signature, lang);
        }
        return this.getBlankMethod(signature, lang);
    }

    private synchronized void addMethod(Method m) {
        this.m_methods.put(m.getSignature(), m);
    }

    public synchronized Method getBlankMethod(String signature, Language.LANGUAGE lang) {
        try {
            Method m = this.m_methods.get(signature);
            if (m != null) {
                return m;
            }
            m = MethodProvider.getMethod(signature, lang);
            this.addMethod(m);
            return m;
        }
        catch (Exception e) {
            try {
                NonClassFunction m = new NonClassFunction(signature, lang);
                this.addMethod(m);
                return m;
            }
            catch (BadMarkupException e1) {
                return null;
            }
        }
    }

    public void addMethodsToMethodCache(Assessment a) throws VDBException {
        this.addToCache(a, true);
    }

    public void addSourceAndSinksToCache(Assessment a) throws VDBException {
        this.addToCache(a, false);
    }

    private void addToCache(Assessment a, boolean add_taint_nodes) throws VDBException {
        HashMap<Language.LANGUAGE, Vdb> vdbs = new HashMap<Language.LANGUAGE, Vdb>();
        for (Finding f : a.getFindingList()) {
            if (f.isLostSink()) {
                this.fireMethodProcessed();
                continue;
            }
            if (vdbs.get(f.getLanguage()) == null) {
                vdbs.put(f.getLanguage(), new Vdb(f.getLanguage()));
            }
            try {
                Method m = null;
                if (f.getTrace() != null) {
                    if (add_taint_nodes) {
                        for (Taint t : f.getTrace().getTaintList()) {
                            m = this.getBlankMethod(t.getSite().getSignature(), f.getLanguage());
                            if (m == null) continue;
                            ((Vdb)vdbs.get(f.getLanguage())).addMethod(m);
                        }
                    } else {
                        m = this.getBlankMethod(f.getTrace().getSource().getSite().getSignature(), f.getLanguage());
                        if (m != null) {
                            ((Vdb)vdbs.get(f.getLanguage())).addMethod(m);
                        }
                        if ((m = this.getBlankMethod(f.getTrace().getSink().getSite().getSignature(), f.getLanguage())) != null) {
                            ((Vdb)vdbs.get(f.getLanguage())).addMethod(m);
                        }
                    }
                } else {
                    m = this.getBlankMethod(f.getSite().getSignature(), f.getLanguage());
                }
                if (m != null) {
                    ((Vdb)vdbs.get(f.getLanguage())).addMethod(m);
                }
                this.fireMethodProcessed();
            }
            catch (Exception e) {
                throw new VDBException(e);
            }
        }
        try {
            for (Language.LANGUAGE l : vdbs.keySet()) {
                vdbs.put(l, VdbProvider.getVdbFromVdb((Vdb)vdbs.get(l)));
                for (Method m : ((Vdb)vdbs.get(l)).getMethods()) {
                    this.addMethod(m);
                }
            }
        }
        catch (VDBGeneralException e) {
            throw new VDBException(e);
        }
    }

    public void addListener(String id, MethodCacheListener l) {
        this.m_listeners.put(id, l);
    }

    public void removeListener(String id) {
        this.m_listeners.remove(id);
    }

    public void fireMethodProcessed() {
        for (MethodCacheListener l : this.m_listeners.values()) {
            l.methodProcessed();
        }
    }

    public void fireMethodAddedToCache() {
        for (MethodCacheListener l : this.m_listeners.values()) {
            l.methodAddedToMap();
        }
    }
}

