/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.vdb.rule;

import com.ibm.appscan.vdb.exception.BadRuleException;
import com.ibm.appscan.vdb.method.Method;
import com.ibm.appscan.vdb.misc.VDBEnums;
import com.ibm.appscan.vdb.rule.BaseRule;
import com.ibm.appscan.vdb.rule.DeleteRule;
import com.ibm.appscan.vdb.rule.Rule;
import java.util.Collection;
import java.util.HashMap;
import java.util.UUID;

public abstract class BaseLogicGate
extends BaseRule {
    private HashMap<String, Rule> m_rules = new HashMap();

    public BaseLogicGate() {
        this.setRuleName(null);
    }

    public boolean isValid() {
        if (this.getRules().size() == 0) {
            return false;
        }
        for (Rule r : this.getRules()) {
            if (r.isValid()) continue;
            return false;
        }
        return true;
    }

    public boolean isMatch(Method m) {
        if (this.getRules().size() == 0) {
            return false;
        }
        return this.analyzeRules(m);
    }

    protected abstract boolean analyzeRules(Method var1);

    public abstract VDBEnums.RULE_GATE_TYPE getType();

    public Rule createRule() {
        return this.createRule(this.getType().toString() + "_Rule_" + UUID.randomUUID().toString());
    }

    public Rule createRule(String name) {
        if (name == null || name.length() == 0) {
            name = "Rule_" + UUID.randomUUID().toString();
        }
        if (this.m_rules.containsKey(name)) {
            name = name + "_" + UUID.randomUUID().toString();
        }
        this.m_rules.put(name, new Rule());
        this.m_rules.get(name).setRuleName(name);
        return this.m_rules.get(name);
    }

    public Rule createDeleteRule() {
        String name = "";
        if (name == null || name.length() == 0) {
            name = "DeleteRule_" + UUID.randomUUID().toString();
        }
        if (this.m_rules.containsKey(name)) {
            name = name + "_" + UUID.randomUUID().toString();
        }
        this.m_rules.put(name, new DeleteRule());
        this.m_rules.get(name).setRuleName(name);
        return this.m_rules.get(name);
    }

    public void addRule(Rule r) {
        if (!this.m_rules.containsKey(r.getRuleName())) {
            this.m_rules.put(r.getRuleName(), r);
        }
    }

    public void deleteRule(Rule r) {
        this.m_rules.remove(r.getRuleName());
    }

    public Collection<Rule> getRules() {
        return this.m_rules.values();
    }

    public Rule getRule(String name) {
        return this.m_rules.get(name);
    }

    public String getDetailText() {
        StringBuffer str = new StringBuffer();
        str.append("(Gate " + (Object)((Object)this.getType()) + ":");
        for (Rule r : this.getRules()) {
            str.append(r.getDetailsText());
        }
        str.append(")");
        return str.toString();
    }

    public boolean applyRule(Method m) throws BadRuleException {
        boolean ret = false;
        for (Rule r : this.getRules()) {
            if (!r.applyRule(m)) continue;
            ret = true;
        }
        return ret;
    }
}

