/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.vdb.rule.method.ao.option;

import com.ibm.appscan.vdb.exception.BadMarkupException;
import com.ibm.appscan.vdb.exception.BadRuleException;
import com.ibm.appscan.vdb.method.Method;
import com.ibm.appscan.vdb.method.markup.ao.ActionObject;
import com.ibm.appscan.vdb.method.markup.ao.Option;
import com.ibm.appscan.vdb.misc.VDBEnums;
import com.ibm.appscan.vdb.provider.EnumProvider;
import com.ibm.appscan.vdb.rule.method.ao.ActionObjectRule;
import com.ibm.appscan.vdb.rule.method.ao.option.OptionMaxCon;
import com.ibm.appscan.vdb.rule.method.ao.option.OptionMinCon;
import com.ibm.appscan.vdb.rule.method.ao.option.OptionName;
import com.ibm.appscan.vdb.rule.method.ao.option.OptionOperator;
import com.ibm.appscan.vdb.rule.method.ao.option.OptionParamPosition;
import com.ibm.appscan.vdb.rule.method.ao.option.OptionValue;

public class OptionRule
extends ActionObjectRule {
    private OptionName m_name;
    private OptionValue m_value;
    private OptionParamPosition m_param;
    private OptionOperator m_operator;
    private OptionMinCon m_min;
    private OptionMaxCon m_max;

    public OptionRule() {
        try {
            this.setAoType(VDBEnums.AO_TYPE.OptionBasedTester);
        }
        catch (BadRuleException e) {
            e.logException();
        }
    }

    @Override
    public boolean isSearchValid() {
        return this.getObtMaxCon().isRuleValid() || this.getObtMinCon().isRuleValid() || this.getObtName().isRuleValid() || this.getObtOperator().isRuleValid() || this.getObtParamPos().isRuleValid() || this.getObtValue().isRuleValid() || this.getVulnerability() != null || this.getSeverity() != VDBEnums.SEVERITY.DEFAULT;
    }

    @Override
    public boolean isRuleValid() {
        return this.getObtName().isRuleValid() && this.getObtOperator().isRuleValid() && this.getObtParamPos().isRuleValid() && this.getVulnerability() != null && this.getSeverity() != VDBEnums.SEVERITY.DEFAULT;
    }

    @Override
    protected ActionObject getRuleActionObject() throws BadRuleException {
        try {
            ActionObject ao = new ActionObject();
            ao.setAoType(VDBEnums.AO_TYPE.OptionBasedTester);
            ao.setVulnerability(this.getVulnRule().getRuleValue());
            ao.setSeverity(this.getSevRule().getSeverity());
            Option obt = new Option();
            obt.setOptionName(this.getOptionName());
            obt.setOptionValue(this.getOptionValue());
            obt.setParameter(this.getOptionParameter());
            obt.setOptionOperator(this.getOptionOperator());
            if (this.getMaxConfidence() != VDBEnums.OPTION_CONFIDENCE.NULL) {
                obt.setMaxCon(this.getMaxConfidence());
            }
            if (this.getMinConfidence() != VDBEnums.OPTION_CONFIDENCE.NULL) {
                obt.setMinCon(this.getMinConfidence());
            }
            ao.addOption(obt);
            return ao;
        }
        catch (BadMarkupException bme) {
            throw new BadRuleException(bme);
        }
    }

    @Override
    public boolean applyRule(Method m) throws BadRuleException {
        try {
            return m.addActionObject(this.getRuleActionObject());
        }
        catch (BadMarkupException e) {
            return false;
        }
    }

    @Override
    public boolean searchRule(Method m) {
        if (this.getRuleOperator() == VDBEnums.RULE_OPERATOR.NULL) {
            return true;
        }
        if (m.getOptionBaseTesters().size() == 0) {
            return false;
        }
        if (!this.isBasicSearch()) {
            return false;
        }
        for (ActionObject ao : m.getOptionBaseTesters()) {
            if (!this.checkAo(ao)) continue;
            for (Option o : ao.getOptions()) {
                boolean _ret = true;
                if (this.getObtName().isRuleValid() && !this.getObtName().searchOption(this.getRuleOperator(), o)) {
                    _ret = false;
                }
                if (this.getObtOperator().isRuleValid() && !this.getObtOperator().searchOption(this.getRuleOperator(), o)) {
                    _ret = false;
                }
                if (this.getObtValue().isRuleValid() && !this.getObtValue().searchOption(this.getRuleOperator(), o)) {
                    _ret = false;
                }
                if (this.getObtParamPos().isRuleValid() && !this.getObtParamPos().searchOption(this.getRuleOperator(), o)) {
                    _ret = false;
                }
                if (this.getObtMaxCon().isRuleValid() && !this.getObtMaxCon().searchOption(this.getRuleOperator(), o)) {
                    _ret = false;
                }
                if (this.getObtMinCon().isRuleValid() && !this.getObtMinCon().searchOption(this.getRuleOperator(), o)) {
                    _ret = false;
                }
                if (!_ret) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getDetailName() {
        return "OBT";
    }

    private OptionName getObtName() {
        if (this.m_name == null) {
            this.m_name = new OptionName();
            this.addBaseRule(this.m_name);
        }
        return this.m_name;
    }

    public void setOptionName(VDBEnums.OPTION_NAME name) throws BadRuleException {
        this.getObtName().setRuleValue(name.toString());
    }

    public VDBEnums.OPTION_NAME getOptionName() {
        return EnumProvider.getOptionName(this.getObtName().getRuleValue());
    }

    private OptionValue getObtValue() {
        if (this.m_value == null) {
            this.m_value = new OptionValue();
            this.addBaseRule(this.m_value);
        }
        return this.m_value;
    }

    public void setOptionValue(String value) throws BadRuleException {
        this.getObtValue().setRuleValue(value);
    }

    public String getOptionValue() {
        return this.getObtValue().getRuleValue();
    }

    private OptionParamPosition getObtParamPos() {
        if (this.m_param == null) {
            this.m_param = new OptionParamPosition();
            this.addBaseRule(this.m_param);
        }
        return this.m_param;
    }

    public void setOptionParameter(String param) throws BadRuleException {
        this.getObtParamPos().setRuleValue(param);
    }

    public String getOptionParameter() {
        return this.getObtParamPos().getRuleValue();
    }

    private OptionOperator getObtOperator() {
        if (this.m_operator == null) {
            this.m_operator = new OptionOperator();
            this.addBaseRule(this.m_operator);
        }
        return this.m_operator;
    }

    public void setOptionOperator(VDBEnums.OPTION_OPERATOR operator) throws BadRuleException {
        this.getObtOperator().setRuleValue(operator.toString());
    }

    public VDBEnums.OPTION_OPERATOR getOptionOperator() {
        return EnumProvider.getOptionOperator(this.getObtOperator().getRuleValue());
    }

    private OptionMinCon getObtMinCon() {
        if (this.m_min == null) {
            this.m_min = new OptionMinCon();
            this.addBaseRule(this.m_min);
        }
        return this.m_min;
    }

    public void setMinConfidence(VDBEnums.OPTION_CONFIDENCE min) throws BadRuleException {
        this.getObtMinCon().setRuleValue(min.toString());
    }

    public VDBEnums.OPTION_CONFIDENCE getMinConfidence() {
        return EnumProvider.getOptionCon(this.getObtMinCon().getRuleValue());
    }

    public OptionMaxCon getObtMaxCon() {
        if (this.m_max == null) {
            this.m_max = new OptionMaxCon();
            this.addBaseRule(this.m_max);
        }
        return this.m_max;
    }

    public void setMaxConfidence(VDBEnums.OPTION_CONFIDENCE max) throws BadRuleException {
        this.getObtMaxCon().setRuleValue(max.toString());
    }

    public VDBEnums.OPTION_CONFIDENCE getMaxConfidence() {
        return EnumProvider.getOptionCon(this.getObtMaxCon().getRuleValue());
    }

    public void setOptionName(String text) throws BadRuleException {
        this.setOptionName(EnumProvider.getOptionName(text));
    }

    public void setOptionOperator(String text) throws BadRuleException {
        this.setOptionOperator(EnumProvider.getOptionOperator(text));
    }

    public void setMinConfidence(String text) throws BadRuleException {
        this.setMinConfidence(EnumProvider.getOptionCon(text));
    }

    public void setMaxConfidence(String text) throws BadRuleException {
        this.setMaxConfidence(EnumProvider.getOptionCon(text));
    }
}

