/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.vdb.rule.special_cases;

import com.ibm.appscan.vdb.exception.BadMarkupException;
import com.ibm.appscan.vdb.exception.BadRuleException;
import com.ibm.appscan.vdb.exception.VDBException;
import com.ibm.appscan.vdb.method.Method;
import com.ibm.appscan.vdb.misc.VDBEnums;
import com.ibm.appscan.vdb.provider.VdbProvider;
import com.ibm.appscan.vdb.rule.SearchRule;
import java.util.ArrayList;

public class SpecialCaseRule
extends SearchRule {
    public ArrayList<VDBEnums.SPECIAL_CASES> m_special_cases = new ArrayList();

    @Override
    public boolean searchRule(Method m) {
        if (this.hasSpecialCase()) {
            return this.searchSpecialCase(m);
        }
        return true;
    }

    @Override
    public boolean isRuleValid() {
        return this.isSearchValid();
    }

    @Override
    public boolean isSearchValid() {
        return this.hasSpecialCase();
    }

    @Override
    public String getDetailName() {
        return "Special Cases";
    }

    public void setSpecialCase(VDBEnums.SPECIAL_CASES specialCase) throws BadRuleException {
        this.setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        this.m_special_cases.add(specialCase);
    }

    public void removeSpecialCase(VDBEnums.SPECIAL_CASES sc) throws BadRuleException {
        this.m_special_cases.remove((Object)sc);
        if (this.m_special_cases.size() == 0) {
            this.setRuleOperator(VDBEnums.RULE_OPERATOR.NULL);
        }
    }

    public boolean isSpecialCase(VDBEnums.SPECIAL_CASES specialCase) {
        return this.m_special_cases.contains((Object)specialCase);
    }

    public boolean hasSpecialCase() {
        return this.m_special_cases.size() != 0;
    }

    @Override
    public String getDetailsText() {
        if (this.hasSpecialCase()) {
            StringBuffer str = new StringBuffer(100);
            str.append("{" + this.getDetailName() + ": ");
            for (VDBEnums.SPECIAL_CASES sc : VDBEnums.SPECIAL_CASES.values()) {
                if (!this.isSpecialCase(sc)) continue;
                str.append(sc.displayName() + ",");
            }
            if (str.length() > 0) {
                str.deleteCharAt(str.length() - 1);
            }
            str.append("}");
            return str.toString();
        }
        return null;
    }

    private boolean searchSpecialCase(Method method) {
        if (this.isSpecialCase(VDBEnums.SPECIAL_CASES.IS_MEMBER)) {
            try {
                if (!method.isMember()) {
                    return false;
                }
            }
            catch (BadMarkupException e) {
                return false;
            }
        }
        if (this.isSpecialCase(VDBEnums.SPECIAL_CASES.NOT_MEMBER)) {
            try {
                if (method.isMember()) {
                    return false;
                }
            }
            catch (BadMarkupException e) {
                return false;
            }
        }
        if (this.isSpecialCase(VDBEnums.SPECIAL_CASES.IS_STATIC) && !method.isStatic()) {
            return false;
        }
        if (this.isSpecialCase(VDBEnums.SPECIAL_CASES.NOT_STATIC) && method.isStatic()) {
            return false;
        }
        if (this.isSpecialCase(VDBEnums.SPECIAL_CASES.IS_CONSTRUCTOR) && !method.isConstructor()) {
            return false;
        }
        if (this.isSpecialCase(VDBEnums.SPECIAL_CASES.NOT_CONSTRUCTOR) && method.isConstructor()) {
            return false;
        }
        if (this.isSpecialCase(VDBEnums.SPECIAL_CASES.IS_GETTER)) {
            try {
                return method.isGetter() || VdbProvider.isGetterType(method);
            }
            catch (VDBException e) {
                return false;
            }
        }
        if (this.isSpecialCase(VDBEnums.SPECIAL_CASES.NOT_GETTER)) {
            try {
                return !method.isGetter() && !VdbProvider.isGetterType(method);
            }
            catch (VDBException e) {
                return false;
            }
        }
        if (this.isSpecialCase(VDBEnums.SPECIAL_CASES.IS_SETTER)) {
            try {
                return method.isSetter() || VdbProvider.isSetterType(method);
            }
            catch (VDBException e) {
                return false;
            }
        }
        if (this.isSpecialCase(VDBEnums.SPECIAL_CASES.NOT_SETTER)) {
            try {
                return !method.isSetter() && !VdbProvider.isSetterType(method);
            }
            catch (VDBException e) {
                return false;
            }
        }
        if (this.isSpecialCase(VDBEnums.SPECIAL_CASES.IS_MARKED_UP) && !method.isMarkedUp()) {
            return false;
        }
        if (this.isSpecialCase(VDBEnums.SPECIAL_CASES.NOT_MARKED_UP) && method.isMarkedUp()) {
            return false;
        }
        if (this.isSpecialCase(VDBEnums.SPECIAL_CASES.HAS_SINK) && method.getSinks().size() == 0) {
            return false;
        }
        if (this.isSpecialCase(VDBEnums.SPECIAL_CASES.NOT_HAVE_SINK) && method.getSinks().size() > 0) {
            return false;
        }
        if (this.isSpecialCase(VDBEnums.SPECIAL_CASES.HAS_SOURCE) && method.getSources().size() == 0) {
            return false;
        }
        if (this.isSpecialCase(VDBEnums.SPECIAL_CASES.NOT_HAVE_SOURCE) && method.getSources().size() > 0) {
            return false;
        }
        if (this.isSpecialCase(VDBEnums.SPECIAL_CASES.HAS_TANT_PROP)) {
            if (method.getTaints().size() == 0) {
                return false;
            }
            if (method.getTaints().size() == 1 && method.isNotSusceptibleToTaint()) {
                return false;
            }
        }
        if (this.isSpecialCase(VDBEnums.SPECIAL_CASES.NOT_TAINT_PROP) && method.getTaints().size() > 0) {
            if (!method.isNotSusceptibleToTaint()) {
                return false;
            }
            return false;
        }
        if (this.isSpecialCase(VDBEnums.SPECIAL_CASES.HAS_NOT_SUSCEPTIBLE_TO_TAINT) && !method.isNotSusceptibleToTaint()) {
            return false;
        }
        if (this.isSpecialCase(VDBEnums.SPECIAL_CASES.NOT_HAVE_NOT_SUSCEPTIBLE_TO_TAINT) && method.isNotSusceptibleToTaint()) {
            return false;
        }
        if (this.isSpecialCase(VDBEnums.SPECIAL_CASES.HAS_TECH) && method.getTechnologies().size() == 0) {
            return false;
        }
        if (this.isSpecialCase(VDBEnums.SPECIAL_CASES.NOT_HAVE_TECH) && method.getTechnologies().size() > 0) {
            return false;
        }
        if (this.isSpecialCase(VDBEnums.SPECIAL_CASES.HAS_MECH) && method.getMechanisms().size() == 0) {
            return false;
        }
        if (this.isSpecialCase(VDBEnums.SPECIAL_CASES.NOT_HAVE_MECH) && method.getMechanisms().size() > 0) {
            return false;
        }
        if (this.isSpecialCase(VDBEnums.SPECIAL_CASES.HAS_NO_TRACE_AO) && method.getSimpleActionObjects().size() == 0) {
            return false;
        }
        if (this.isSpecialCase(VDBEnums.SPECIAL_CASES.NOT_HAVE_NO_TRACE_AO) && method.getSimpleActionObjects().size() > 0) {
            return false;
        }
        if (this.isSpecialCase(VDBEnums.SPECIAL_CASES.HAS_PROPERTIES) && method.getProperties().size() == 0) {
            return false;
        }
        if (this.isSpecialCase(VDBEnums.SPECIAL_CASES.NOT_HAVE_PROPERTIES) && method.getProperties().size() > 0) {
            return false;
        }
        if (this.isSpecialCase(VDBEnums.SPECIAL_CASES.HAS_OPTION_BASED_TESTER) && method.getOptionBaseTesters().size() == 0) {
            return false;
        }
        if (this.isSpecialCase(VDBEnums.SPECIAL_CASES.NOT_HAVE_OPTON_BASED_TESTER) && method.getOptionBaseTesters().size() > 0) {
            return false;
        }
        if (this.isSpecialCase(VDBEnums.SPECIAL_CASES.HAS_CALLBACK) && !method.isCallBack()) {
            return false;
        }
        return !this.isSpecialCase(VDBEnums.SPECIAL_CASES.NOT_HAVE_CALLBACK) || !method.isCallBack();
    }

    @Override
    public boolean allowsContains() {
        return false;
    }
}

