/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.clazz.info;

import com.hcl.clazz.info.MethodInfo;
import com.hcl.clazz.info.Util;
import com.hcl.clazz.info.visitors.ClassNameVisitorImpl;
import com.hcl.clazz.info.visitors.ClassVisitorImpl;
import com.ibm.appscan.common.utils.IOUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public class ClassInfo {
    private byte[] m_data;
    private String m_class_name;
    private String m_package_name;
    private HashSet<String> m_dependent_classes;
    private ClassVisitorImpl m_class_visitor;
    private ArrayList<MethodInfo> m_methods;
    private File m_original_file;
    private File m_jsp_file;

    public ClassInfo(File file) throws IOException {
        this.m_original_file = file.getAbsoluteFile();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            IOUtil.write((File)file, (OutputStream)out);
            this.m_data = out.toByteArray();
        }
        finally {
            IOUtil.close((Closeable)out);
        }
    }

    public void setOriginalFileLocation(File file) {
        this.m_original_file = file;
    }

    public void setJspFileLocation(File jsp) {
        this.m_jsp_file = jsp;
    }

    public HashSet<String> getClassFields() {
        return this.getClassVisitor().getPrivateClassFields();
    }

    public ClassInfo(byte[] data, String path) {
        this.m_data = data;
        this.m_original_file = new File(path);
    }

    public File getOriginalFileLocation() {
        return this.m_original_file;
    }

    public void save(File base_dir) throws IOException {
        File out = new File(base_dir + File.separator + this.getClassName().replace(".", File.separator) + ".class");
        if (out.getParentFile() != null) {
            out.getParentFile().mkdirs();
        }
        IOUtil.write((InputStream)new ByteArrayInputStream(this.getData()), (File)out);
    }

    public String getPackageName() {
        if (this.m_package_name == null) {
            this.m_package_name = this.getClassName();
            if (this.getClassName().contains(".")) {
                this.m_package_name = this.getClassName().substring(0, this.getClassName().lastIndexOf("."));
            }
        }
        return this.m_package_name;
    }

    public byte[] getData() {
        return this.m_data;
    }

    public byte[] getDataFromJspOrClassFile() throws IOException {
        if (this.m_jsp_file != null) {
            ByteArrayOutputStream ret = new ByteArrayOutputStream();
            ret.write(this.getClassName().getBytes());
            IOUtil.write((File)this.m_jsp_file, (OutputStream)ret);
            return ret.toByteArray();
        }
        return this.getData();
    }

    public String getClassName() {
        if (this.m_class_name == null) {
            ClassReader reader = new ClassReader(this.getData());
            ClassNameVisitorImpl cv = new ClassNameVisitorImpl(Util.ASM_API_VERSION);
            reader.accept((ClassVisitor)cv, 1);
            this.m_class_name = cv.getClassName();
        }
        return this.m_class_name;
    }

    public HashSet<String> getDependentClasses() {
        if (this.m_dependent_classes == null) {
            this.m_dependent_classes = new HashSet<String>(this.getClassVisitor().getDependencies());
            this.m_dependent_classes.remove(this.getClassName());
            this.m_dependent_classes.remove("java.lang.String");
            this.m_dependent_classes.remove("java.lang.Object");
        }
        return this.m_dependent_classes;
    }

    public ArrayList<MethodInfo> getMethods() {
        if (this.m_methods == null) {
            this.m_methods = new ArrayList<MethodInfo>(this.getClassVisitor().getMethods());
            Collections.sort(this.m_methods, new Comparator<MethodInfo>(){

                @Override
                public int compare(MethodInfo o1, MethodInfo o2) {
                    return o1.getFullSignature().compareTo(o2.getFullSignature());
                }
            });
        }
        return this.m_methods;
    }

    private ClassVisitorImpl getClassVisitor() {
        if (this.m_class_visitor == null) {
            ClassReader reader = new ClassReader(this.getData());
            this.m_class_visitor = new ClassVisitorImpl(Util.ASM_API_VERSION, this.getClassName());
            reader.accept((ClassVisitor)this.m_class_visitor, 0);
        }
        return this.m_class_visitor;
    }

    public static String getCleanClassName(String name) {
        if (name == null) {
            return name;
        }
        if ((name = name.replaceAll("/", ".")).contains("[L")) {
            name = name.replaceAll("\\[L", "");
        }
        if (name.contains(")L")) {
            name = name.replaceAll("\\)L", "");
        }
        if (name.contains(";")) {
            name = name.replaceAll(";", "");
        }
        if (name.startsWith("L")) {
            name = name.substring(1);
        }
        if (name.startsWith("[")) {
            name = name.substring(1);
        }
        return name;
    }
}

