/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.clazz.info.visitors;

import com.hcl.clazz.info.ClassReferences;
import com.hcl.clazz.info.MethodInfo;
import com.hcl.clazz.info.Util;
import com.hcl.clazz.info.visitors.AnnotationVisitorImpl;
import com.hcl.clazz.info.visitors.FieldVisitorImpl;
import com.hcl.clazz.info.visitors.MethodVisitorImpl;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.appscan.vdb.exception.BadMarkupException;
import com.ibm.appscan.vdb.exception.VDBException;
import java.util.ArrayList;
import java.util.HashSet;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.ModuleVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.TypePath;

public class ClassVisitorImpl
extends ClassVisitor {
    private String m_class_name = "";
    private HashSet<String> m_dependencies;
    private ArrayList<MethodInfo> m_methods = new ArrayList();
    private ArrayList<MethodVisitorImpl> m_method_visitors = new ArrayList();
    private ClassReferences m_class_ref = new ClassReferences();
    public static boolean DEBUG = SystemUtil.isDebug();
    public static int LEVEL = 0;
    private int m_api;
    private HashSet<String> m_fields;

    public HashSet<String> getDependencies() {
        if (this.m_dependencies == null) {
            this.m_dependencies = this.m_class_ref.getClassesCalled();
        }
        return this.m_dependencies;
    }

    public ArrayList<MethodInfo> getMethods() {
        return this.m_methods;
    }

    public HashSet<String> getPrivateClassFields() {
        if (this.m_fields == null) {
            this.m_fields = new HashSet();
        }
        return this.m_fields;
    }

    public ClassVisitorImpl(int api, String class_name) {
        super(api);
        this.m_api = api;
        this.m_class_name = class_name;
    }

    public void visitOuterClass(String owner, String name, String desc) {
        ClassVisitorImpl.printDebug("CLASS_OUTER_CLASS_OWNER", this.m_class_name, owner, 2);
        this.m_class_ref.addClassCalled(owner);
        ClassVisitorImpl.printDebug("CLASS_OUTER_CLASS_DESC", this.m_class_name, desc, 2);
        this.m_class_ref.addClassCalled(desc);
        super.visitOuterClass(owner, name, desc);
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        AnnotationVisitorImpl ret = new AnnotationVisitorImpl(this.m_class_ref, this.m_api);
        ClassVisitorImpl.printDebug("CLASS_ANN_DESC", this.m_class_name, desc, 3);
        this.m_class_ref.addClassCalled(desc);
        return ret;
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        FieldVisitorImpl ret = new FieldVisitorImpl(this.m_class_ref, this.m_api);
        this.m_class_ref.addClassCalled(desc);
        ClassVisitorImpl.printDebug("CLASS_FIELD_NAME", this.m_class_name, name, 3);
        this.getPrivateClassFields().add(name);
        ClassVisitorImpl.printDebug("CLASS_FIELD_DESC", this.m_class_name, desc, 3);
        this.m_class_ref.addClassCalled(signature);
        ClassVisitorImpl.printDebug("CLASS_FIELD_SIG", this.m_class_name, signature, 3);
        if (value instanceof Type) {
            ClassVisitorImpl.printDebug("CLASS_FIELD_VALUE_TYPE", this.m_class_name, value.toString(), 3);
            this.m_class_ref.addClassCalled((Type)value);
        } else if (value instanceof Handle) {
            ClassVisitorImpl.printDebug("CLASS_FIELD_VALUE_HANDLE", this.m_class_name, value.toString(), 3);
            this.m_class_ref.addClassCalled((Handle)value);
        }
        return ret;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        ClassVisitorImpl.printDebug("CLASS_METHOD_NAME", this.m_class_name, name, 4);
        ClassVisitorImpl.printDebug("CLASS_METHOD_DESC", this.m_class_name, desc, 4);
        this.m_class_ref.addClassCalled(desc);
        ClassVisitorImpl.printDebug("CLASS_METHOD_SIG", this.m_class_name, signature, 4);
        this.m_class_ref.addClassCalled(signature);
        ClassVisitorImpl.printDebug("CLASS_METHOD_EXC", this.m_class_name, exceptions, 4);
        this.m_class_ref.addClassCalled(exceptions);
        MethodInfo m = null;
        try {
            m = new MethodInfo(this.m_class_name, access, name, desc, signature, exceptions);
            this.m_methods.add(m);
            ClassVisitorImpl.printDebug("CLASS_METHOD_VDB_SIG", this.m_class_name, m.getFullSignature(), 4);
            MethodVisitorImpl mv = new MethodVisitorImpl(this.m_class_ref, Util.ASM_API_VERSION, this.m_class_name, m);
            this.m_method_visitors.add(mv);
            return mv;
        }
        catch (BadMarkupException e) {
            e.printStackTrace();
        }
        catch (VDBException e) {
            e.printStackTrace();
        }
        return super.visitMethod(access, name, desc, signature, exceptions);
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        AnnotationVisitorImpl ret = new AnnotationVisitorImpl(this.m_class_ref, this.m_api);
        ClassVisitorImpl.printDebug("CLASS_TYPE_ANN_DESC", this.m_class_name, desc, 3);
        this.m_class_ref.addClassCalled(desc);
        return ret;
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        ClassVisitorImpl.printDebug("CLASS_INNER_CLASS_OUTER_NAME", this.m_class_name, outerName, 2);
        this.m_class_ref.addClassCalled(outerName);
        super.visitInnerClass(name, outerName, innerName, access);
    }

    public ModuleVisitor visitModule(String name, int access, String version) {
        ClassVisitorImpl.printDebug("CLASS_MODULE_NAME", this.m_class_name, name, 2);
        this.m_class_ref.addClassCalled(name);
        return super.visitModule(name, access, version);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        ClassVisitorImpl.printDebug("CLASS_VISIT_SUPER_NAME", this.m_class_name, superName, 1);
        this.m_class_ref.addClassCalled(superName);
        ClassVisitorImpl.printDebug("CLASS_VISIT_INERFACE", this.m_class_name, interfaces, 1);
        this.m_class_ref.addClassCalled(interfaces);
        ClassVisitorImpl.printDebug("CLASS_VISIT_NAME", this.m_class_name, name, 1);
        this.m_class_ref.addClassCalled(name);
        ClassVisitorImpl.printDebug("CLASS_VISIT_SIG", this.m_class_name, signature, 1);
        this.m_class_ref.addClassCalled(signature);
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public static void printDebug(String title, String classname, String[] datas, int level) {
        if (DEBUG && datas != null) {
            for (String s : datas) {
                ClassVisitorImpl.printDebug(title, classname, s, level);
            }
        }
    }

    public static void printDebug(String classname, int num, int level) {
        if (DEBUG) {
            System.out.println(classname + ":" + num + ":" + level);
        }
    }

    public static void printDebug(String title, String classname, Object o, int level) {
        if (o != null) {
            ClassVisitorImpl.printDebug(title, classname, o.toString(), level);
        }
    }

    public static void printDebug(String title, String classname, Label l, int level) {
        if (l != null) {
            ClassVisitorImpl.printDebug(title, classname, l.toString(), level);
        }
    }

    public static void printDebug(String title, String classname, Handle handle, int level) {
        if (handle != null) {
            ClassVisitorImpl.printDebug(title, classname, handle.toString(), level);
        }
    }

    public static void printDebug(String title, String classname, String data, int level) {
        if (DEBUG && level >= LEVEL) {
            System.out.println(title + ":" + classname + ":" + data);
        }
    }
}

