/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.clazz.info.visitors;

import com.hcl.clazz.info.ClassReferences;
import com.hcl.clazz.info.MethodInfo;
import com.hcl.clazz.info.visitors.AnnotationVisitorImpl;
import com.hcl.clazz.info.visitors.ClassVisitorImpl;
import java.util.HashSet;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.TypePath;

public class MethodVisitorImpl
extends MethodVisitor {
    private ClassReferences m_class_ref;
    private String m_class_name;
    private int m_api;
    private MethodInfo m_method_info;

    public MethodVisitorImpl(ClassReferences class_ref, int api, String class_name, MethodInfo mi) {
        super(api);
        this.m_class_name = class_name;
        this.m_class_ref = class_ref;
        this.m_api = api;
        this.m_method_info = mi;
    }

    public HashSet<String> getClassesCalled() {
        return this.m_class_ref.getClassesCalled();
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        ClassVisitorImpl.printDebug("METHOD_FIELD_DESC", this.m_class_name, desc, 5);
        this.m_class_ref.addClassCalled(desc);
        ClassVisitorImpl.printDebug("METHOD_FIELD_OWNER", this.m_class_name, owner, 5);
        this.m_class_ref.addClassCalled(owner);
        ClassVisitorImpl.printDebug("METHOD_FIELD_NAME", this.m_class_name, name, 5);
        this.m_method_info.getClassFieldsPresent().add(name);
        super.visitFieldInsn(opcode, owner, name, desc);
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        ClassVisitorImpl.printDebug("METHOD_LOCAL_VAR_DESC", this.m_class_name, desc, 4);
        this.m_class_ref.addClassCalled(desc);
        ClassVisitorImpl.printDebug("METHOD_LOCAL_VAR_NAME", this.m_class_name, name, 4);
        ClassVisitorImpl.printDebug("METHOD_LOCAL_VAR_SIG", this.m_class_name, signature, 4);
        super.visitLocalVariable(name, desc, signature, start, end, index);
    }

    public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
        ClassVisitorImpl.printDebug("METHOD_INVOKE_DYN_HANDLE", this.m_class_name, bsm, 4);
        this.m_class_ref.addClassCalled(bsm);
        ClassVisitorImpl.printDebug("METHOD_INVOKE_DYN_DESC", this.m_class_name, desc, 4);
        this.m_class_ref.addClassCalled(desc);
        for (Object o : bsmArgs) {
            if (o instanceof Type) {
                ClassVisitorImpl.printDebug("METHOD_INVOKE_DYN_BSM_ARG_TYPE", this.m_class_name, o.toString(), 4);
                this.m_class_ref.addClassCalled(o.toString());
                continue;
            }
            if (o instanceof Handle) {
                ClassVisitorImpl.printDebug("METHOD_INVOKE_DYN_BSM_ARG_HANDLE", this.m_class_name, o.toString(), 4);
                this.m_class_ref.addClassCalled((Handle)o);
                continue;
            }
            ClassVisitorImpl.printDebug("METHOD_INVOKE_DYN_BSM_ARG_NOT_TYPE_1", this.m_class_name, o.toString(), 4);
        }
        super.visitInvokeDynamicInsn(name, desc, bsm, bsmArgs);
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        ClassVisitorImpl.printDebug("METHOD_VISIT_MULTI_NEW_ARRAY_DESC", this.m_class_name, desc, 4);
        this.m_class_ref.addClassCalled(desc);
        super.visitMultiANewArrayInsn(desc, dims);
    }

    public void visitTypeInsn(int opcode, String type) {
        ClassVisitorImpl.printDebug("METHOD_TYPE_INS_TYPE", this.m_class_name, type, 4);
        this.m_class_ref.addClassCalled(type);
        super.visitTypeInsn(opcode, type);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        ClassVisitorImpl.printDebug("METHOD_INST_DESC", this.m_class_name, desc, 4);
        this.m_class_ref.addClassCalled(desc);
        ClassVisitorImpl.printDebug("METHOD_INST_NAME", this.m_class_name, name, 4);
        ClassVisitorImpl.printDebug("METHOD_INST_OWNER", this.m_class_name, owner, 4);
        this.m_class_ref.addClassCalled(owner);
        super.visitMethodInsn(opcode, owner, name, desc, itf);
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        AnnotationVisitorImpl ret = new AnnotationVisitorImpl(this.m_class_ref, this.m_api);
        ClassVisitorImpl.printDebug("METHOD_ANN_DESC", this.m_class_name, desc, 4);
        this.m_class_ref.addClassCalled(desc);
        return ret;
    }

    public AnnotationVisitor visitInsnAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        AnnotationVisitorImpl ret = new AnnotationVisitorImpl(this.m_class_ref, this.m_api);
        ClassVisitorImpl.printDebug("METHOD_INST_ANN", this.m_class_name, desc, 4);
        this.m_class_ref.addClassCalled(desc);
        return ret;
    }

    public AnnotationVisitor visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start, Label[] end, int[] index, String desc, boolean visible) {
        AnnotationVisitorImpl ret = new AnnotationVisitorImpl(this.m_class_ref, this.m_api);
        ClassVisitorImpl.printDebug("METHOD_LOCAL_VAR_DESC", this.m_class_name, desc, 4);
        this.m_class_ref.addClassCalled(desc);
        return ret;
    }

    public void visitParameter(String name, int access) {
        ClassVisitorImpl.printDebug("METHOD_PARAM_NAME", this.m_class_name, name, 4);
        this.m_class_ref.addClassCalled(name);
        super.visitParameter(name, access);
    }

    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        AnnotationVisitorImpl ret = new AnnotationVisitorImpl(this.m_class_ref, this.m_api);
        ClassVisitorImpl.printDebug("METHOD_PARAM_ANN_DESC", this.m_class_name, desc, 4);
        this.m_class_ref.addClassCalled(desc);
        return ret;
    }

    public AnnotationVisitor visitTryCatchAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        AnnotationVisitorImpl ret = new AnnotationVisitorImpl(this.m_class_ref, this.m_api);
        this.m_class_ref.addClassCalled(desc);
        return ret;
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        AnnotationVisitorImpl ret = new AnnotationVisitorImpl(this.m_class_ref, this.m_api);
        ClassVisitorImpl.printDebug("METHOD_TYPE_ANN_DESC", this.m_class_name, desc, 4);
        this.m_class_ref.addClassCalled(desc);
        return ret;
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        ClassVisitorImpl.printDebug("METHOD_TRY_CATCH_TYPE", this.m_class_name, type, 4);
        this.m_class_ref.addClassCalled(type);
        super.visitTryCatchBlock(start, end, handler, type);
    }

    public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
        for (Object o : local) {
            if (o == null || !o.toString().contains("/")) continue;
            ClassVisitorImpl.printDebug("METHOD_FRAME_LOCAL", this.m_class_name, o, 4);
            this.m_class_ref.addClassCalled(o.toString());
        }
        for (Object o : stack) {
            if (o == null || !o.toString().contains("/")) continue;
            ClassVisitorImpl.printDebug("METHOD_FRAME_STACK", this.m_class_name, o, 4);
            this.m_class_ref.addClassCalled(o.toString());
        }
        super.visitFrame(type, nLocal, local, nStack, stack);
    }

    public void visitAnnotableParameterCount(int parameterCount, boolean visible) {
        ClassVisitorImpl.printDebug("METHOD_ANNOTABLE_PARAMS_COUNT", this.m_class_name, parameterCount, 4);
        super.visitAnnotableParameterCount(parameterCount, visible);
    }
}

