/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.sdk.app;

import com.hcl.appscan.sdk.CoreConstants;
import com.hcl.appscan.sdk.app.IApplicationProvider;
import com.hcl.appscan.sdk.auth.IASEAuthenticationProvider;
import com.hcl.appscan.sdk.http.HttpResponse;
import com.hcl.appscan.sdk.http.HttpsClient;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.wink.json4j.JSONArray;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONObject;

public class ASEApplicationProvider
implements IApplicationProvider,
CoreConstants {
    private Map<String, String> m_applications;
    private IASEAuthenticationProvider m_authProvider;

    public ASEApplicationProvider(IASEAuthenticationProvider provider) {
        this.m_authProvider = provider;
    }

    @Override
    public Map<String, String> getApplications() {
        if (this.m_applications == null) {
            this.loadApplications();
        }
        return this.m_applications;
    }

    @Override
    public String getAppName(String id) {
        return this.getApplications().get(id);
    }

    private void loadApplications() {
        if (this.m_authProvider.isTokenExpired()) {
            return;
        }
        this.m_applications = new HashMap<String, String>();
        String url = this.m_authProvider.getServer() + "/api/applications" + "?columns=name";
        Map<String, String> headers = this.m_authProvider.getAuthorizationHeader(true);
        headers.putAll(Collections.singletonMap("Range", "items=0-999999"));
        HttpsClient client = new HttpsClient();
        try {
            HttpResponse response = client.get(url, headers, null);
            if (!response.isSuccess()) {
                return;
            }
            JSONArray array = (JSONArray)response.getResponseBodyAsJSON();
            if (array == null) {
                return;
            }
            for (int i = 0; i < array.length(); ++i) {
                JSONObject object = array.getJSONObject(i);
                String id = object.getString("id");
                String name = object.getString("name");
                this.m_applications.put(id, name);
            }
        }
        catch (IOException | JSONException e) {
            this.m_applications = null;
        }
    }
}

