/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cfg;

import com.ibm.wala.cfg.AbstractCFG;
import com.ibm.wala.cfg.IBasicBlock;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ssa.SSAArrayLengthInstruction;
import com.ibm.wala.ssa.SSAArrayLoadInstruction;
import com.ibm.wala.ssa.SSAArrayStoreInstruction;
import com.ibm.wala.ssa.SSACheckCastInstruction;
import com.ibm.wala.ssa.SSAConditionalBranchInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAGotoInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSAMonitorInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPiInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.ssa.SSASwitchInstruction;
import com.ibm.wala.ssa.SSAThrowInstruction;
import com.ibm.wala.util.collections.ArrayIterator;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.impl.NodeWithNumber;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;

public class InducedCFG
extends AbstractCFG<SSAInstruction, BasicBlock> {
    private static final boolean DEBUG = false;
    private final BasicBlock[] i2block;
    private final Context context;
    private final SSAInstruction[] instructions;

    public InducedCFG(SSAInstruction[] instructions, IMethod method, Context context) {
        super(method);
        if (instructions == null) {
            throw new IllegalArgumentException("instructions is null");
        }
        if (method == null) {
            throw new IllegalArgumentException("method is null");
        }
        this.context = context;
        this.instructions = instructions;
        this.i2block = new BasicBlock[instructions.length];
        if (instructions.length == 0) {
            this.makeEmptyBlocks();
        } else {
            this.makeBasicBlocks();
        }
        this.init();
        this.computeEdges();
    }

    @Override
    public int hashCode() {
        return this.context.hashCode() ^ this.getMethod().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof InducedCFG && this.getMethod().equals(((InducedCFG)o).getMethod()) && this.context.equals(((InducedCFG)o).context);
    }

    public SSAInstruction[] getInstructions() {
        return this.instructions;
    }

    private void computeEdges() {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            BasicBlock b = (BasicBlock)it.next();
            if (b.equals(this.exit())) continue;
            b.computeOutgoingEdges();
        }
        this.clearPis(this.getInstructions());
    }

    private void clearPis(SSAInstruction[] instructions) {
        for (int i = 0; i < instructions.length; ++i) {
            if (!(instructions[i] instanceof SSAPiInstruction)) continue;
            instructions[i] = null;
        }
    }

    private void makeEmptyBlocks() {
        BasicBlock b = new BasicBlock(-1);
        this.addNode(b);
    }

    protected BranchVisitor makeBranchVisitor(boolean[] r) {
        return new BranchVisitor(r);
    }

    protected PEIVisitor makePEIVisitor(boolean[] r) {
        return new PEIVisitor(r);
    }

    private void makeBasicBlocks() {
        SSAInstruction[] instructions = this.getInstructions();
        boolean[] r = new boolean[instructions.length];
        r[0] = true;
        BranchVisitor branchVisitor = this.makeBranchVisitor(r);
        PEIVisitor peiVisitor = this.makePEIVisitor(r);
        for (int i = 0; i < instructions.length; ++i) {
            if (instructions[i] == null) continue;
            branchVisitor.setIndex(i);
            instructions[i].visit(branchVisitor);
            peiVisitor.setIndex(i);
            instructions[i].visit(peiVisitor);
        }
        assert (instructions.length <= r.length);
        BasicBlock b = null;
        for (int i = 0; i < r.length; ++i) {
            if (r[i]) {
                b = new BasicBlock(i);
                this.addNode(b);
                int j = i;
                while (instructions[j] instanceof SSAPhiInstruction) {
                    b.addPhi((SSAPhiInstruction)instructions[j]);
                    if (++j < instructions.length) continue;
                }
            }
            if (instructions[i] instanceof SSAPiInstruction) {
                b.addPi((SSAPiInstruction)instructions[i]);
            }
            this.i2block[i] = b;
        }
        BasicBlock exit = new BasicBlock(-1);
        this.addNode(exit);
        this.clearPhis(instructions);
    }

    private void clearPhis(SSAInstruction[] instructions) {
        for (int i = 0; i < instructions.length; ++i) {
            if (!(instructions[i] instanceof SSAPhiInstruction)) continue;
            instructions[i] = null;
        }
    }

    @Override
    public BasicBlock getBlockForInstruction(int index) {
        if (this.i2block[index] == null) {
            Assertions.productionAssertion((boolean)false, (String)("unexpected null for " + index));
        }
        return this.i2block[index];
    }

    @Override
    public String toString() {
        StringBuffer s = new StringBuffer("");
        Iterator it = this.iterator();
        while (it.hasNext()) {
            BasicBlock bb = (BasicBlock)it.next();
            s.append("BB").append(this.getNumber(bb)).append("\n");
            for (int j = bb.getFirstInstructionIndex(); j <= bb.getLastInstructionIndex(); ++j) {
                s.append("  ").append(j).append("  ").append(this.getInstructions()[j]).append("\n");
            }
            Iterator<BasicBlock> succNodes = this.getSuccNodes(bb);
            while (succNodes.hasNext()) {
                s.append("    -> BB").append(this.getNumber((IBasicBlock)succNodes.next())).append("\n");
            }
        }
        return s.toString();
    }

    @Override
    public int getProgramCounter(int index) {
        if (this.getInstructions().length <= index) {
            throw new IllegalArgumentException("invalid index " + index + " " + this.getInstructions().length);
        }
        if (this.getInstructions()[index] instanceof SSAInvokeInstruction) {
            return ((SSAInvokeInstruction)this.getInstructions()[index]).getCallSite().getProgramCounter();
        }
        return index;
    }

    public int getIndexFromIIndex(int iindex) {
        if (iindex <= 0) {
            throw new IllegalArgumentException("The iindex may not be negative (is " + iindex + ". Method: " + this.getMethod() + ", Contenxt: " + this.context);
        }
        SSAInstruction[] instructions = this.getInstructions();
        if (instructions == null) {
            throw new IllegalStateException("This CFG contains no Instructions? " + this.getMethod() + ", Contenxt: " + this.context);
        }
        for (int i = 0; i < instructions.length; ++i) {
            if (instructions[i] == null || instructions[i].iindex != iindex) continue;
            return i;
        }
        throw new IllegalStateException("The searched iindex (" + iindex + ") does not exist! In " + this.getMethod() + ", Contenxt: " + this.context);
    }

    public Collection<SSAPhiInstruction> getAllPhiInstructions() {
        HashSet result = HashSetFactory.make();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            BasicBlock b = (BasicBlock)it.next();
            result.addAll(b.getPhis());
        }
        return result;
    }

    public class BasicBlock
    extends NodeWithNumber
    implements IBasicBlock<SSAInstruction> {
        private Collection<SSAPhiInstruction> phis;
        private ArrayList<SSAPiInstruction> pis;
        private final int start;

        public Collection<SSAPhiInstruction> getPhis() {
            return this.phis == null ? Collections.emptyList() : Collections.unmodifiableCollection(this.phis);
        }

        public void addPhi(SSAPhiInstruction phiInstruction) {
            if (this.phis == null) {
                this.phis = new ArrayList<SSAPhiInstruction>(1);
            }
            this.phis.add(phiInstruction);
        }

        public Collection<SSAPiInstruction> getPis() {
            return this.pis == null ? Collections.emptyList() : Collections.unmodifiableCollection(this.pis);
        }

        public void addPi(SSAPiInstruction piInstruction) {
            if (this.pis == null) {
                this.pis = new ArrayList(1);
            }
            this.pis.add(piInstruction);
        }

        public boolean equals(Object arg0) {
            if (arg0 != null && this.getClass().equals(arg0.getClass())) {
                BasicBlock other = (BasicBlock)arg0;
                return this.start == other.start && this.getMethod().equals(other.getMethod());
            }
            return false;
        }

        BasicBlock(int start) {
            this.start = start;
        }

        private void addExceptionalEdges(SSAInstruction last) {
            if (last == null) {
                System.err.println("Missing last SSA-Instruction in basic block (null).");
                return;
            }
            if (last.isPEI()) {
                this.addExceptionalEdgeTo((BasicBlock)InducedCFG.this.exit());
            }
        }

        private void addNormalEdgeTo(BasicBlock b) {
            InducedCFG.this.addNormalEdge(this, b);
        }

        private void addExceptionalEdgeTo(BasicBlock b) {
            InducedCFG.this.addExceptionalEdge(this, b);
        }

        private void computeOutgoingEdges() {
            int tgt;
            SSAInstruction last = InducedCFG.this.getInstructions()[this.getLastInstructionIndex()];
            this.addExceptionalEdges(last);
            if (last instanceof SSAGotoInstruction && (tgt = ((SSAGotoInstruction)last).getTarget()) != -1) {
                int tgtNd = InducedCFG.this.getIndexFromIIndex(tgt);
                BasicBlock target = null;
                Iterator it = InducedCFG.this.iterator();
                while (it.hasNext()) {
                    BasicBlock candid = (BasicBlock)it.next();
                    if (candid.getFirstInstructionIndex() != tgtNd) continue;
                    target = candid;
                    break;
                }
                if (target == null) {
                    System.err.println("Error retreiving the Node with IIndex " + tgt + " (in array at " + tgtNd + ")");
                    System.err.println("The associated Instruction " + InducedCFG.this.instructions[tgtNd] + " does not start a basic block");
                    assert (false);
                }
                this.addNormalEdgeTo(target);
            }
            int normalSuccNodeNumber = this.getGraphNodeId() + 1;
            if (last.isFallThrough()) {
                this.addNormalEdgeTo((BasicBlock)InducedCFG.this.getNode(normalSuccNodeNumber));
            }
            if (last instanceof SSAGotoInstruction) {
                this.addNormalEdgeTo(InducedCFG.this.getBlockForInstruction(((SSAGotoInstruction)last).getTarget()));
            } else if (last instanceof SSAConditionalBranchInstruction) {
                this.addNormalEdgeTo(InducedCFG.this.getBlockForInstruction(((SSAConditionalBranchInstruction)last).getTarget()));
            } else if (last instanceof SSASwitchInstruction) {
                int[] targets = ((SSASwitchInstruction)last).getCasesAndLabels();
                for (int i = 1; i < targets.length; i += 2) {
                    this.addNormalEdgeTo(InducedCFG.this.getBlockForInstruction(targets[i]));
                }
            }
            if (this.pis != null) {
                this.updatePiInstrs(normalSuccNodeNumber);
            }
            if (last instanceof SSAReturnInstruction) {
                BasicBlock exit = (BasicBlock)InducedCFG.this.exit();
                this.addNormalEdgeTo(exit);
            }
        }

        private void updatePiInstrs(int normalSuccNodeNumber) {
            for (int i = 0; i < this.pis.size(); ++i) {
                SSAPiInstruction pi = this.pis.get(i);
                SSAInstructionFactory insts = this.getMethod().getDeclaringClass().getClassLoader().getInstructionFactory();
                this.pis.set(i, insts.PiInstruction(-1, pi.getDef(), pi.getVal(), this.getGraphNodeId(), normalSuccNodeNumber, pi.getCause()));
            }
        }

        @Override
        public int getFirstInstructionIndex() {
            return this.start;
        }

        @Override
        public int getLastInstructionIndex() {
            int exitNumber = InducedCFG.this.getNumber(InducedCFG.this.exit());
            if (this.getGraphNodeId() == exitNumber) {
                return -2;
            }
            if (this.getGraphNodeId() == exitNumber - 1) {
                return InducedCFG.this.getInstructions().length - 1;
            }
            BasicBlock next = (BasicBlock)InducedCFG.this.getNode(this.getGraphNodeId() + 1);
            return next.getFirstInstructionIndex() - 1;
        }

        @Override
        public boolean isCatchBlock() {
            return false;
        }

        public int hashCode() {
            return 1153 * this.getGraphNodeId() + this.getMethod().hashCode();
        }

        public String toString() {
            return "BB[Induced]" + this.getNumber() + " - " + this.getMethod().getSignature();
        }

        @Override
        public boolean isExitBlock() {
            return this.getLastInstructionIndex() == -2;
        }

        @Override
        public boolean isEntryBlock() {
            return this.getNumber() == 0;
        }

        @Override
        public IMethod getMethod() {
            return InducedCFG.this.getMethod();
        }

        public boolean endsInPEI() {
            return InducedCFG.this.getInstructions()[this.getLastInstructionIndex()].isPEI();
        }

        public boolean endsInReturn() {
            return InducedCFG.this.getInstructions()[this.getLastInstructionIndex()] instanceof SSAReturnInstruction;
        }

        @Override
        public int getNumber() {
            return InducedCFG.this.getNumber(this);
        }

        @Override
        public Iterator<SSAInstruction> iterator() {
            return new ArrayIterator((Object[])InducedCFG.this.getInstructions(), this.getFirstInstructionIndex(), this.getLastInstructionIndex());
        }
    }

    public class PEIVisitor
    extends SSAInstruction.Visitor {
        private final boolean[] r;
        int index = 0;

        protected PEIVisitor(boolean[] r) {
            this.r = r;
        }

        void setIndex(int i) {
            this.index = i;
        }

        protected void breakBasicBlock() {
            int j;
            for (j = this.index + 1; j < InducedCFG.this.instructions.length && InducedCFG.this.instructions[j] instanceof SSAPiInstruction; ++j) {
            }
            if (j < InducedCFG.this.instructions.length && !this.r[j]) {
                this.r[j] = true;
            }
        }

        @Override
        public void visitArrayLength(SSAArrayLengthInstruction instruction) {
            this.breakBasicBlock();
        }

        @Override
        public void visitArrayLoad(SSAArrayLoadInstruction instruction) {
            this.breakBasicBlock();
        }

        @Override
        public void visitArrayStore(SSAArrayStoreInstruction instruction) {
            this.breakBasicBlock();
        }

        @Override
        public void visitCheckCast(SSACheckCastInstruction instruction) {
            this.breakBasicBlock();
        }

        @Override
        public void visitGet(SSAGetInstruction instruction) {
            this.breakBasicBlock();
        }

        @Override
        public void visitInvoke(SSAInvokeInstruction instruction) {
            this.breakBasicBlock();
        }

        @Override
        public void visitMonitor(SSAMonitorInstruction instruction) {
            this.breakBasicBlock();
        }

        @Override
        public void visitNew(SSANewInstruction instruction) {
            this.breakBasicBlock();
        }

        @Override
        public void visitPut(SSAPutInstruction instruction) {
            this.breakBasicBlock();
        }

        @Override
        public void visitThrow(SSAThrowInstruction instruction) {
            this.breakBasicBlock();
        }
    }

    public class BranchVisitor
    extends SSAInstruction.Visitor {
        private final boolean[] r;
        int index = 0;

        protected BranchVisitor(boolean[] r) {
            this.r = r;
        }

        void setIndex(int i) {
            this.index = i;
        }

        @Override
        public void visitGoto(SSAGotoInstruction instruction) {
            this.breakBasicBlock(this.index);
            int jumpTarget = InducedCFG.this.getIndexFromIIndex(instruction.getTarget());
            assert (InducedCFG.this.instructions[jumpTarget] != null) : "GoTo cant go to null";
            this.breakBasicBlock(jumpTarget - 1);
        }

        @Override
        public void visitConditionalBranch(SSAConditionalBranchInstruction instruction) {
            this.breakBasicBlock(this.index);
        }

        @Override
        public void visitSwitch(SSASwitchInstruction instruction) {
            this.breakBasicBlock(this.index);
            int[] targets = instruction.getCasesAndLabels();
            for (int i = 1; i < targets.length; i += 2) {
                this.r[targets[i]] = true;
            }
        }

        @Override
        public void visitPhi(SSAPhiInstruction instruction) {
            if (!(InducedCFG.this.instructions[this.index - 1] instanceof SSAPhiInstruction)) {
                this.breakBasicBlock(this.index - 1);
            }
        }

        @Override
        public void visitReturn(SSAReturnInstruction instruction) {
            this.breakBasicBlock(this.index);
        }

        @Override
        public void visitThrow(SSAThrowInstruction instruction) {
            this.breakBasicBlock(this.index);
        }

        protected void breakBasicBlock(int index) {
            int j;
            for (j = index + 1; j < InducedCFG.this.instructions.length && InducedCFG.this.instructions[j] instanceof SSAPiInstruction; ++j) {
            }
            if (j < InducedCFG.this.instructions.length && !this.r[j]) {
                this.r[j] = true;
            }
        }
    }
}

