/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cfg.exc.intra;

import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.cfg.exc.ExceptionPruningAnalysis;
import com.ibm.wala.cfg.exc.intra.IntraprocNullPointerAnalysis;
import com.ibm.wala.cfg.exc.intra.MethodState;
import com.ibm.wala.cfg.exc.intra.NullPointerState;
import com.ibm.wala.cfg.exc.intra.ParameterState;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.MonitorUtil;
import com.ibm.wala.util.graph.GraphIntegrity;
import java.util.Iterator;
import java.util.List;

public class SSACFGNullPointerAnalysis
implements ExceptionPruningAnalysis<SSAInstruction, ISSABasicBlock> {
    private final TypeReference[] ignoredExceptions;
    private IntraprocNullPointerAnalysis<ISSABasicBlock> intra = null;
    private final IR ir;
    private final ParameterState initialState;
    private final MethodState mState;

    public SSACFGNullPointerAnalysis(TypeReference[] ignoredExceptions, IR ir, ParameterState paramState, MethodState mState) {
        this.ignoredExceptions = ignoredExceptions != null ? (TypeReference[])ignoredExceptions.clone() : null;
        this.ir = ir;
        this.initialState = paramState == null ? ParameterState.createDefault(ir.getMethod()) : paramState;
        this.mState = mState == null ? MethodState.DEFAULT : mState;
    }

    @Override
    public int compute(MonitorUtil.IProgressMonitor progress) throws GraphIntegrity.UnsoundGraphException, CancelException {
        SSACFG orig = this.ir.getControlFlowGraph();
        this.intra = new IntraprocNullPointerAnalysis<ISSABasicBlock>(this.ir, orig, this.ignoredExceptions, this.initialState, this.mState);
        this.intra.run(progress);
        return this.intra.getNumberOfDeletedEdges();
    }

    @Override
    public ControlFlowGraph<SSAInstruction, ISSABasicBlock> getCFG() {
        if (this.intra == null) {
            throw new IllegalStateException("Run compute(IProgressMonitor) first.");
        }
        return this.intra.getPrunedCFG();
    }

    @Override
    public boolean hasExceptions() {
        if (this.intra == null) {
            throw new IllegalStateException("Run compute(IProgressMonitor) first.");
        }
        ControlFlowGraph<SSAInstruction, ISSABasicBlock> cfg = this.intra.getPrunedCFG();
        boolean hasException = false;
        Iterator iterator = cfg.iterator();
        while (iterator.hasNext()) {
            List<ISSABasicBlock> succ;
            ISSABasicBlock bb = (ISSABasicBlock)iterator.next();
            if (bb.getLastInstruction() == null || (succ = cfg.getExceptionalSuccessors(bb)) == null || succ.isEmpty()) continue;
            hasException = true;
            break;
        }
        return hasException;
    }

    @Override
    public NullPointerState getState(ISSABasicBlock bb) {
        if (this.intra == null) {
            throw new IllegalStateException("Run compute(IProgressMonitor) first.");
        }
        return this.intra.getState(bb);
    }
}

