/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.slicer;

import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.slicer.Statement;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;

public abstract class HeapStatement
extends Statement {
    private final PointerKey loc;

    public HeapStatement(CGNode node, PointerKey loc) {
        super(node);
        if (loc == null) {
            throw new IllegalArgumentException("loc is null");
        }
        this.loc = loc;
    }

    public PointerKey getLocation() {
        return this.loc;
    }

    public static final class HeapReturnCallee
    extends HeapStatement {
        public HeapReturnCallee(CGNode node, PointerKey loc) {
            super(node, loc);
        }

        @Override
        public Statement.Kind getKind() {
            return Statement.Kind.HEAP_RET_CALLEE;
        }

        @Override
        public int hashCode() {
            return this.getLocation().hashCode() + 9533 * this.getNode().hashCode() + 9631;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof HeapReturnCallee) {
                HeapReturnCallee other = (HeapReturnCallee)obj;
                return this.getNode().equals(other.getNode()) && this.getLocation().equals(other.getLocation());
            }
            return false;
        }

        @Override
        public String toString() {
            return this.getKind().toString() + ":" + this.getNode() + " " + this.getLocation();
        }
    }

    public static final class HeapReturnCaller
    extends HeapStatement {
        private final int callIndex;

        public HeapReturnCaller(CGNode node, int callIndex, PointerKey loc) {
            super(node, loc);
            this.callIndex = callIndex;
        }

        @Override
        public Statement.Kind getKind() {
            return Statement.Kind.HEAP_RET_CALLER;
        }

        public int getCallIndex() {
            return this.callIndex;
        }

        public SSAAbstractInvokeInstruction getCall() {
            return (SSAAbstractInvokeInstruction)this.getNode().getIR().getInstructions()[this.callIndex];
        }

        @Override
        public String toString() {
            return this.getKind().toString() + ":" + this.getNode() + " " + this.getLocation() + " call:" + this.getCall();
        }

        @Override
        public int hashCode() {
            return this.getLocation().hashCode() + 8887 * this.callIndex + 8731 * this.getNode().hashCode() + 7919;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof HeapReturnCaller) {
                HeapReturnCaller other = (HeapReturnCaller)obj;
                return this.getNode().equals(other.getNode()) && this.getLocation().equals(other.getLocation()) && this.callIndex == other.callIndex;
            }
            return false;
        }
    }

    public static final class HeapParamCallee
    extends HeapStatement {
        public HeapParamCallee(CGNode node, PointerKey loc) {
            super(node, loc);
        }

        @Override
        public Statement.Kind getKind() {
            return Statement.Kind.HEAP_PARAM_CALLEE;
        }

        @Override
        public int hashCode() {
            return this.getLocation().hashCode() + 7727 * this.getNode().hashCode() + 7841;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof HeapParamCallee) {
                HeapParamCallee other = (HeapParamCallee)obj;
                return this.getNode().equals(other.getNode()) && this.getLocation().equals(other.getLocation());
            }
            return false;
        }

        @Override
        public String toString() {
            return this.getKind().toString() + ":" + this.getNode() + " " + this.getLocation();
        }
    }

    public static final class HeapParamCaller
    extends HeapStatement {
        private final int callIndex;

        public HeapParamCaller(CGNode node, int callIndex, PointerKey loc) {
            super(node, loc);
            this.callIndex = callIndex;
        }

        @Override
        public Statement.Kind getKind() {
            return Statement.Kind.HEAP_PARAM_CALLER;
        }

        public int getCallIndex() {
            return this.callIndex;
        }

        public SSAAbstractInvokeInstruction getCall() {
            return (SSAAbstractInvokeInstruction)this.getNode().getIR().getInstructions()[this.callIndex];
        }

        @Override
        public String toString() {
            return this.getKind().toString() + ":" + this.getNode() + " " + this.getLocation() + " call:" + this.getCall();
        }

        @Override
        public int hashCode() {
            return this.getLocation().hashCode() + 4289 * this.callIndex + 4133 * this.getNode().hashCode() + 8831;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof HeapParamCaller) {
                HeapParamCaller other = (HeapParamCaller)obj;
                return this.getNode().equals(other.getNode()) && this.getLocation().equals(other.getLocation()) && this.callIndex == other.callIndex;
            }
            return false;
        }
    }
}

