/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.discovery.java;

import com.hcl.appscan.discovery.java.classpathManager.ClasspathManager;
import com.hcl.appscan.discovery.java.utils.IClasspathContributor;
import com.hcl.appscan.discovery.java.utils.IJavaStrategy;
import com.hcl.clazz.info.ClassInfo;
import com.hcl.irx.stage.java.JavaTargetValidator;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.Language;
import com.ibm.appscan.common.error.AppScanException;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.model.IBuildInfo;
import com.ibm.appscan.common.model.IScanFile;
import com.ibm.appscan.common.model.IScanTargetMinProxy;
import com.ibm.appscan.common.utils.ArchiveUtil;
import com.ibm.appscan.common.utils.ClasspathBuilder;
import com.ibm.appscan.common.utils.FileUtil;
import com.ibm.appscan.discovery.IStrategyFactoryRegistry;
import com.ibm.appscan.discovery.dir.CrawlingStrategy;
import com.ibm.appscan.discovery.util.PackageNameUtil;
import com.ibm.appscan.exclude.ExclusionProvider;
import com.ibm.appscan.exclude.exclusions.BaseExclusion;
import com.ibm.appscan.exclude.exclusions.ExclusionException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class JARStrategy
extends CrawlingStrategy
implements IJavaStrategy {
    private List<IClasspathContributor> m_contributors = new ArrayList<IClasspathContributor>();
    private Set<String> m_namespaces = new HashSet<String>();
    private File m_crawlRoot;

    public JARStrategy() {
    }

    JARStrategy(File file) {
        this(file, null);
    }

    JARStrategy(File file, IStrategyFactoryRegistry registry) {
        this.init(file, registry);
    }

    public void init(File file, IStrategyFactoryRegistry registry) {
        super.init(file, registry);
    }

    public String getType() {
        return "bytecode";
    }

    public String getLanguageType() {
        return "Java";
    }

    protected String[] getCategories(IBuildInfo buildInfo) {
        return new String[]{"category.java"};
    }

    public void addClasspathContributor(IClasspathContributor contributor) {
        this.m_contributors.add(contributor);
    }

    protected boolean stageScanTarget(IScanTargetMinProxy proxy, IProgress progress) {
        proxy.inheritedSetBuildInfo("additional_classpath", null);
        proxy.inheritedSetBuildInfo("classpath", null);
        proxy.inheritedSetBuildInfo("src_root", null);
        File target = this.getRoot(proxy);
        String parentPath = target.getParent();
        if (target.isFile()) {
            this.m_crawlRoot = this.getStagingDirectory(true, target.getName());
            try {
                Iterator iterator = ArchiveUtil.unzip((File)target, (File)this.m_crawlRoot, (String[])new String[0]).iterator();
                while (iterator.hasNext()) {
                    Message message;
                    Message message2 = message = (Message)iterator.next();
                    message2.getClass();
                    message.setMessageSource(new Message.MessageSource(message2, proxy.getPath(), null));
                    proxy.getLogManager().log(message);
                }
            }
            catch (AppScanException | IOException e) {
                proxy.getErrorManager().reportError(e.getMessage(), e);
                return false;
            }
        } else {
            this.m_crawlRoot = target;
        }
        ClasspathBuilder builder = new ClasspathBuilder(proxy);
        for (IClasspathContributor contributor : this.m_contributors) {
            builder.appendToClasspath(contributor.getClasspath());
        }
        builder.appendToClasspath(this.m_crawlRoot, parentPath);
        builder.appendToClasspath(ClasspathManager.getParentClasspath((IScanTargetMinProxy)proxy));
        builder.appendToClasspath(this.m_crawlRoot.getPath());
        builder.commit();
        return true;
    }

    protected void validateScanTarget(IScanTargetMinProxy proxy, IProgress progress, Set<IScanFile> files) {
        proxy.getValidationIssues().addAll(new JavaTargetValidator(files, proxy).validate(progress));
    }

    protected void getNameSpaces(IScanTargetMinProxy proxy, Set<IScanFile> files) {
        if (this.m_namespaces.isEmpty()) {
            for (IScanFile scanFile : files) {
                if (!FileUtil.getFileExtension((File)scanFile.getFile()).equalsIgnoreCase("class") || scanFile.isExcluded()) continue;
                try {
                    this.m_namespaces.add(PackageNameUtil.trimPackageName((String)new ClassInfo(scanFile.getFile()).getPackageName()));
                }
                catch (IOException e) {
                    proxy.getErrorManager().reportError(e.getMessage(), (Throwable)e);
                }
            }
            proxy.getNameSpaces().addAll(this.m_namespaces);
        }
    }

    protected File getCrawlRoot(IScanTargetMinProxy proxy) {
        return this.m_crawlRoot;
    }

    protected boolean isThirdPartyExclusion(IScanFile scanFile, IScanTargetMinProxy proxy) {
        String className = scanFile.getSourcePath();
        className = className.replaceAll("\\\\", ".");
        className = className.replaceAll("/", ".");
        try {
            BaseExclusion exclusionProvider = ExclusionProvider.getExclusion((Language.LANGUAGE)Language.LANGUAGE.JAVA);
            return exclusionProvider.isClassExcluded(className);
        }
        catch (ExclusionException e) {
            proxy.getErrorManager().reportError(e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

