/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.discovery.java.stage;

import com.hcl.irx.slice.JavaStagerForSlicing;
import com.hcl.irx.stage.java.JavaStager;
import com.hcl.irx.stage.java.JavaTargetValidator;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.model.IBuildInfo;
import com.ibm.appscan.common.model.IScanFile;
import com.ibm.appscan.common.model.IScanTargetMinProxy;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.appscan.discovery.dir.FileCollectorStrategy;
import com.ibm.appscan.discovery.java.IJavaStagerConstants;
import com.ibm.appscan.exclude.exclusions.ExclusionException;
import java.io.File;
import java.io.IOException;
import java.util.Set;

public class JavaStagerStrategy
extends FileCollectorStrategy
implements IJavaStagerConstants {
    private File m_crawl_root;
    private JavaStager m_stager;

    public JavaStagerStrategy(File crawl_root, JavaStager stager) {
        this.init(crawl_root, null);
        this.m_crawl_root = crawl_root;
        this.m_stager = stager;
    }

    public String getType() {
        return "bytecode";
    }

    protected Set<IScanFile> findScanFiles(IScanTargetMinProxy proxy, IProgress progress) {
        JavaStager stager = this.getStager(proxy, progress);
        Set files = stager.getStagedScanFiles();
        proxy.getNameSpaces().addAll(stager.getAnalysisPackagesTrimmed());
        return files;
    }

    public boolean buildScanTarget(IScanTargetMinProxy proxy, IProgress progress) {
        proxy.inheritedSetBuildInfo("additional_classpath", null);
        proxy.inheritedSetBuildInfo("web_content_dir", null);
        proxy.inheritedSetBuildInfo("jsp_compiler_args", null);
        proxy.inheritedSetBuildInfo("classpath", null);
        proxy.inheritedSetBuildInfo("bootstrap_classpath", null);
        proxy.inheritedSetBuildInfo("extension_jars", null);
        proxy.inheritedSetBuildInfo("src_root", null);
        proxy.inheritedSetBuildInfo("jsp_compiler", "Default Tomcat JSP Compiler");
        return true;
    }

    public boolean stageScanTarget(IScanTargetMinProxy proxy, IProgress progress) {
        if (this.m_crawl_root.isFile()) {
            try {
                this.getStager(proxy, progress).stageFileOrDirectory(this.m_crawl_root);
            }
            catch (IOException e) {
                proxy.getLogManager().log((Exception)e);
            }
            catch (ExclusionException e) {
                proxy.getLogManager().log((Exception)((Object)e));
            }
        }
        return true;
    }

    public String getLanguageType() {
        return "Java";
    }

    public String getName() {
        return this.getClass().getName();
    }

    protected String[] getCategories(IBuildInfo buildInfo) {
        return new String[]{"category.java.stager"};
    }

    protected File getCrawlRoot(IScanTargetMinProxy proxy) {
        return this.m_crawl_root;
    }

    protected void validateScanTarget(IScanTargetMinProxy proxy, IProgress progress, Set<IScanFile> files) {
        proxy.getValidationIssues().addAll(new JavaTargetValidator(files, proxy).validate(progress));
    }

    private JavaStager getStager(IScanTargetMinProxy proxy, IProgress progress) {
        if (this.m_stager == null) {
            File stage = new File(proxy.getScanHome(), "stage");
            this.m_stager = SystemUtil.useSlicerForJavaFiles() ? new JavaStagerForSlicing(stage, proxy, progress, proxy.getIncludes(), proxy.getExcludes()) : new JavaStager(stage, proxy, progress, proxy.getIncludes(), proxy.getExcludes());
        }
        return this.m_stager;
    }

    protected String getExtensionGroup() {
        return "java";
    }

    protected boolean acceptFile(File file) {
        return true;
    }
}

