/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.discovery.tomcat;

import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.model.CustomTargetInfo;
import com.ibm.appscan.common.model.IScanFile;
import com.ibm.appscan.common.model.IScanTargetMinProxy;
import com.ibm.appscan.common.model.IScanTargetProxy;
import com.ibm.appscan.common.model.ScanTargetStrategy;
import com.ibm.appscan.common.model.StringPattern;
import com.ibm.appscan.discovery.IStrategyFactoryRegistry;
import com.ibm.appscan.discovery.Strategy;
import com.ibm.appscan.discovery.tomcat.Messages;
import com.ibm.appscan.internal.discovery.tomcat.TomcatServer;
import com.ibm.appscan.internal.discovery.tomcat.compilers.TomcatJSPCompilerType;
import java.io.File;
import java.util.Set;

public class TomcatStrategy
extends Strategy {
    private static final String WAR_EXT = ".war";
    private File m_tomcatBase;
    private IStrategyFactoryRegistry m_registry;
    private String m_jspCompiler = null;
    private boolean m_unpackWARs = true;

    public TomcatStrategy() {
    }

    TomcatStrategy(File directory, IStrategyFactoryRegistry registry) {
        this.m_tomcatBase = directory;
        this.m_registry = registry;
        this.m_jspCompiler = directory.getPath();
    }

    public void init(File directory, IStrategyFactoryRegistry registry) {
        this.m_tomcatBase = directory;
        this.m_registry = registry;
        this.m_jspCompiler = directory.getPath();
        new TomcatJSPCompilerType().autoCreate(this.m_jspCompiler);
    }

    public String getName() {
        return this.m_tomcatBase.getName();
    }

    public String getType() {
        return Messages.getMessage("tomcat", new Object[0]);
    }

    public String getPath() {
        return this.m_tomcatBase.getPath();
    }

    public String getStrategyClass() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public StringPattern getAdjustedPattern(StringPattern pattern) {
        String str = pattern.toString();
        boolean isDotWar = str.toLowerCase().endsWith(WAR_EXT);
        if (this.m_unpackWARs && isDotWar) {
            return new StringPattern(str.substring(0, str.length() - 4));
        }
        if (!this.m_unpackWARs && !isDotWar) {
            return new StringPattern(str + WAR_EXT);
        }
        return super.getAdjustedPattern(pattern);
    }

    private void createTarget(IScanTargetProxy proxy, File webapp) {
        ScanTargetStrategy strategy = this.m_registry.getStrategy(webapp);
        if (strategy != null) {
            CustomTargetInfo info = new CustomTargetInfo();
            info.getBuildInfos().put("jsp_compiler", this.m_jspCompiler);
            proxy.newScanTarget(strategy, info);
        }
    }

    public void findScanTargets(IScanTargetProxy proxy, IProgress progress) {
        TomcatServer server = new TomcatServer(this.m_tomcatBase, (IScanTargetMinProxy)proxy);
        File[] webapps = server.getAppBase().listFiles();
        if (webapps != null) {
            this.m_unpackWARs = server.unpackWARs();
            for (File webapp : webapps) {
                if (this.m_unpackWARs != webapp.isDirectory() || webapp.getName().startsWith(".")) continue;
                this.createTarget(proxy, webapp);
            }
        }
    }

    protected Set<IScanFile> findScanFiles(IScanTargetMinProxy proxy, IProgress progress) {
        return null;
    }
}

