/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.discovery.jetbrains.utils;

import com.hcl.appscan.discovery.jetbrains.utils.Module;
import com.ibm.appscan.common.CommonCore;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class JetBrainsUtil {
    public static final String DOT_IDEA_PATH = ".idea";
    public static final String MODULES_XML_PATH = "/modules.xml";

    public static List<Module> getModules(String projectPath) {
        ArrayList<Module> modules = new ArrayList<Module>();
        File projectRootDir = new File(projectPath);
        File modules_xml_file = new File(projectRootDir, ".idea/modules.xml");
        try {
            List<String> moduleList = JetBrainsUtil.getModuleList(modules_xml_file.getPath());
            for (String moduleUrl : moduleList) {
                Module module = new Module(moduleUrl, projectPath);
                modules.add(module);
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            CommonCore.getLogManager().log(e);
        }
        return modules;
    }

    private static List<String> getModuleList(String moduels_xml_path) throws ParserConfigurationException, IOException, SAXException {
        ArrayList<String> moduleList = new ArrayList<String>();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = dbf.newDocumentBuilder();
        Document document = documentBuilder.parse(moduels_xml_path);
        NodeList nodeList = document.getElementsByTagName("module");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element module_Element = (Element)nodeList.item(i);
            String fileurl = module_Element.getAttribute("fileurl");
            moduleList.add(fileurl);
        }
        return moduleList;
    }
}

