/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.internal.discovery.jetbrains;

import com.hcl.appscan.discovery.jetbrains.Messages;
import com.hcl.appscan.discovery.jetbrains.utils.Module;
import com.hcl.appscan.internal.discovery.jetbrains.JetBrainsJavaModuleStrategy;
import com.hcl.appscan.internal.discovery.jetbrains.JetBrainsSourceCodeModuleStrategy;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.model.IScanFile;
import com.ibm.appscan.common.model.IScanTargetMinProxy;
import com.ibm.appscan.common.model.IScanTargetProxy;
import com.ibm.appscan.common.model.ScanTargetStrategy;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.appscan.discovery.DiscoveryCore;
import com.ibm.appscan.discovery.IStrategyFactoryRegistry;
import com.ibm.appscan.discovery.Strategy;
import com.ibm.appscan.internal.discovery.StrategyFactoryRegistry;
import java.io.File;
import java.util.Set;

public class JetBrainsModuleStrategy
extends Strategy {
    private Module m_module;
    private StrategyFactoryRegistry m_registry;

    public JetBrainsModuleStrategy() {
    }

    public JetBrainsModuleStrategy(Module module, IStrategyFactoryRegistry registry) {
        this.m_module = module;
        this.init(module.getDirectory(), registry);
    }

    public void init(File fileOrDirectory, IStrategyFactoryRegistry registry) {
        this.m_registry = (StrategyFactoryRegistry)registry;
    }

    public String getName() {
        return this.m_module.getName();
    }

    public String getType() {
        return "JetBrains Module";
    }

    public String getPath() {
        return this.m_module.getDirectory().getPath();
    }

    public String getStrategyClass() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void findScanTargets(IScanTargetProxy proxy, IProgress progress) {
        if (!SystemUtil.isSourceCodeOnly() && "JAVA_MODULE".equalsIgnoreCase(this.m_module.getType())) {
            for (String outputFolder : this.m_module.getOutputDirectories()) {
                proxy.newScanTarget((ScanTargetStrategy)new JetBrainsJavaModuleStrategy(this.m_module, new File(outputFolder), DiscoveryCore.getThirdPartyLibTarget(), this.m_registry));
            }
        } else if (this.m_module.getSourceDirectories().isEmpty()) {
            proxy.getLogManager().log(new Message(2, Messages.getMessage("module.not.found", this.m_module.getName())));
        } else {
            for (String sourceFolder : this.m_module.getSourceDirectories()) {
                if (!sourceFolder.isEmpty()) {
                    proxy.newScanTarget((ScanTargetStrategy)new JetBrainsSourceCodeModuleStrategy(sourceFolder));
                    continue;
                }
                proxy.getLogManager().log(new Message(2, Messages.getMessage("module.source.folder.not.found", this.m_module.getName(), this.m_module.getDirectory().getName())));
            }
        }
    }

    protected Set<IScanFile> findScanFiles(IScanTargetMinProxy proxy, IProgress progress) {
        return null;
    }
}

