/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.ifa;

import com.hcl.appscan.ifa.Util;
import com.hcl.appscan.ifa.common.IIfaLayer;
import com.hcl.appscan.ifa.common.IfaTarget;
import com.hcl.appscan.ifa.nlp.model.Trace.BaseTraceModel;
import com.hcl.appscan.ifa.notes.Notes;
import com.ibm.appscan.assessment.model.Finding;
import com.ibm.appscan.common.Language;
import com.ibm.appscan.common.logging.Message;
import java.util.ArrayList;

public abstract class BaseTraceIfaLayer
implements IIfaLayer {
    private BaseTraceModel m_model;

    protected BaseTraceIfaLayer(BaseTraceModel m) {
        this.m_model = m;
    }

    public void close() throws Exception {
        this.m_model.close();
    }

    public void applyIfa(IfaTarget t) {
        ArrayList arr = new ArrayList(t.size());
        t.forEach(f -> arr.add(f));
        try {
            this.m_model.getPredictedValue(arr).forEach((f, value) -> {
                if ((double)value.floatValue() > 0.5) {
                    Util.setIfa2Note(f, Notes.getMessage("probability", value));
                    t.includeFinding(f);
                } else {
                    Util.setIfa2Note(f, Notes.getMessage("probability.uninteresting", Float.valueOf(1.0f - value.floatValue())));
                    t.excludeFinding(f);
                }
            });
        }
        catch (Exception e) {
            t.logException(e);
        }
        t.addMessage(new Message(1, Notes.getMessage("ifa.nlp.version.used", this.m_model.getVersion())));
    }

    public Object getSentence(Finding f) {
        return this.m_model.getSentence(f);
    }

    public static boolean predicate(Finding f) {
        return (f.getLanguage() == Language.LANGUAGE.JAVA || f.getLanguage() == Language.LANGUAGE.DOT_NET) && f.getTrace() != null;
    }
}

