/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.irx.slice;

import com.hcl.irx.slice.IrxCache;
import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.error.AppScanException;
import com.ibm.appscan.common.utils.IOUtil;
import com.ibm.appscan.common.utils.SystemUtil;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.Random;

public class IrxResultCache
extends IrxCache {
    private File m_cache_path;

    private File getIrxResultCacheHome() {
        if (this.m_cache_path == null) {
            String cacheRootDirectory = null;
            if (SystemUtil.isPropertySet((String)"IRX_RESULT_CACHE_HOME")) {
                cacheRootDirectory = System.getProperty("IRX_RESULT_CACHE_HOME");
                File currentFile = new File(cacheRootDirectory);
                if (!currentFile.exists()) {
                    cacheRootDirectory = System.getProperty("user.home");
                }
            } else {
                cacheRootDirectory = System.getProperty("user.home");
            }
            this.m_cache_path = Paths.get(cacheRootDirectory, ".appscan", "irx_result_cache").toFile();
            this.m_cache_path.mkdirs();
        }
        return this.m_cache_path;
    }

    @Override
    protected boolean insertCacheEntry(String key, File source) throws IOException {
        File file = new File(this.getIrxResultCacheHome(), key);
        if (!file.exists()) {
            IOUtil.copy((File)source, (File)file);
            return true;
        }
        file.setLastModified(new Date().getTime());
        return false;
    }

    @Override
    protected void deleteAllFilesInCache() {
        Path cachePath = this.getIrxResultCacheHome().toPath();
        try (DirectoryStream<Path> files = Files.newDirectoryStream(cachePath);){
            for (Path file : files) {
                File currentFile = file.toFile();
                currentFile.delete();
            }
        }
        catch (IOException e) {
            CommonCore.getLogManager().log((Exception)e);
        }
    }

    @Override
    protected InputStream getCacheEntry(String key) throws AppScanException, IOException {
        File entry = new File(this.getIrxResultCacheHome(), key);
        if (entry.exists()) {
            try {
                entry.setLastModified(new Date().getTime());
                return new FileInputStream(entry);
            }
            catch (FileNotFoundException e) {
                throw new AppScanException((Throwable)e);
            }
        }
        return null;
    }

    @Override
    protected int getCacheVersionToUse() {
        return 3;
    }

    @Override
    protected byte[] getBytesFromObjectData(Object o) throws NoSuchAlgorithmException, IOException {
        File ipva = (File)o;
        return this.mergeInTargetInfoSrcPath(Files.readAllBytes(ipva.toPath()), new File(ipva.getParentFile(), ".targetinfo"));
    }

    @Override
    protected byte[] getBytesFromAppScanSettings() throws NoSuchAlgorithmException, IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            output.write(new byte[]{(byte)(CommonCore.getConfiguration().getSettingValueBooleanDefaultFalse("can_wafl_gen") ? 1 : 0)});
            output.write(new byte[]{(byte)(CommonCore.getConfiguration().getSettingValueBooleanDefaultFalse("validation_flow_aware") ? 1 : 0)});
            output.write(new byte[]{(byte)(CommonCore.getConfiguration().getSettingValueBooleanDefaultFalse("deep_field_tracking") ? 1 : 0)});
            output.write(new byte[]{(byte)(CommonCore.getConfiguration().getSettingValueBooleanDefaultFalse("automatic_callback_markup") ? 1 : 0)});
            output.write(new byte[]{(byte)(CommonCore.getConfiguration().getSettingValueBooleanDefaultFalse("automatic_propagator_markup") ? 1 : 0)});
            output.write(new byte[]{(byte)(CommonCore.getConfiguration().getSettingValueBooleanDefaultFalse("prune_if_tainted") ? 1 : 0)});
            output.write(new byte[]{(byte)(CommonCore.getConfiguration().getSettingValueBooleanDefaultFalse("log_sources_for_root") ? 1 : 0)});
            output.write(new byte[]{(byte)(CommonCore.getConfiguration().getSettingValueBooleanDefaultFalse("no_inline_validation") ? 1 : 0)});
            output.write(new byte[]{(byte)(CommonCore.getConfiguration().getSettingValueBooleanDefaultFalse("suppress_processing_restricted_errors") ? 1 : 0)});
            output.write(new byte[]{(byte)(CommonCore.getConfiguration().getSettingValueBooleanDefaultFalse("accumulate_taint_in_fields") ? 1 : 0)});
            output.write(new byte[]{(byte)(CommonCore.getConfiguration().getSettingValueBooleanDefaultFalse("show_taint_propagators") ? 1 : 0)});
            output.write(new byte[]{(byte)(CommonCore.getConfiguration().getSettingValueBooleanDefaultFalse("reachable_single_std_override") ? 1 : 0)});
            output.write(new byte[]{(byte)(CommonCore.getConfiguration().getSettingValueBooleanDefaultFalse("process_security_annotations") ? 1 : 0)});
            output.write(CommonCore.getConfiguration().getSettingValue("prototypical_traces").getBytes());
            output.write(CommonCore.getConfiguration().getSettingValue("ipva_prune_size").getBytes());
            output.write(CommonCore.getConfiguration().getSettingValue("ipva_max_prune_size").getBytes());
            output.write(CommonCore.getConfiguration().getSettingValue("adjust_prune_size_threshold").getBytes());
            output.write(CommonCore.getConfiguration().getSettingValue("virtual_call_target_count").getBytes());
            output.write(CommonCore.getConfiguration().getSettingValue("virtual_call_auto_callback_threshold").getBytes());
            output.write(CommonCore.getConfiguration().getSettingValue("cma_compute_limit").getBytes());
            output.write(CommonCore.getConfiguration().getSettingValue("ipva_time_limit").getBytes());
        }
        catch (IOException e) {
            CommonCore.getLogManager().log((Exception)e);
        }
        finally {
            IOUtil.close((Closeable)output);
        }
        return output.toByteArray();
    }

    @Override
    protected String getSettingForMaxSpaceAllowed() {
        return "IRX_RESULT_CACHE_SPACE";
    }

    @Override
    protected String getSettingForMaxEntriesdAllowed() {
        return "IRX_RESULT_CACHE_MAX_COUNT";
    }

    @Override
    protected String getSettingForClearAllCheck() {
        return "IRX_RESULT_CACHE_CLEAR_ALL";
    }

    @Override
    protected long getMaxCacheSpaceAllowed_() {
        return 0x500000000L;
    }

    @Override
    protected long getMaxEntriesAllowed_() {
        return 60000L;
    }

    @Override
    protected long getCacheEntryCount() {
        if (this.getIrxResultCacheHome().exists()) {
            return this.getIrxResultCacheHome().listFiles().length;
        }
        return 0L;
    }

    @Override
    protected void reduceCacheEntry() {
        if (this.getIrxResultCacheHome().exists()) {
            Path cachePath = this.getIrxResultCacheHome().toPath();
            try (DirectoryStream<Path> files = Files.newDirectoryStream(cachePath);){
                for (Path file : files) {
                    if (new Random().nextInt(100) % 2 != 0) continue;
                    file.toFile().delete();
                }
            }
            catch (IOException e) {
                CommonCore.getLogManager().log((Exception)e);
            }
        }
    }

    @Override
    protected long getUsedSpaceInCache() {
        long irxCacheUsedSpace = 0L;
        Path cachePath = this.getIrxResultCacheHome().toPath();
        try (DirectoryStream<Path> files = Files.newDirectoryStream(cachePath);){
            for (Path file : files) {
                File currentFile = file.toFile();
                irxCacheUsedSpace += currentFile.length();
            }
        }
        catch (IOException e) {
            CommonCore.getLogManager().log((Exception)e);
        }
        return irxCacheUsedSpace;
    }
}

