/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.frameworks;

import com.ibm.appscan.frameworks.FileLocations;
import com.ibm.appscan.frameworks.FrameworksInput;
import com.ibm.appscan.frameworks.java.JavaFrameworkInfoGenerator;
import com.ibm.appscan.frameworks.java.WAFLSpecGen;
import com.ibm.appscan.frameworks.specinfo.BeanDecl;
import com.ibm.appscan.frameworks.specinfo.CallSiteReplacement;
import com.ibm.appscan.frameworks.specinfo.IFrameworkInfo;
import com.ibm.appscan.frameworks.specinfo.ISyntheticMethod;
import com.ibm.appscan.frameworks.specinfo.SyntheticExpr;
import com.ibm.appscan.frameworks.util.VDBJavaUtil;
import com.ibm.appscan.frameworks.util.WalaUtil;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.andromeda.frameworks.synthetic.SyntheticFrameworkClass;
import com.ibm.wala.andromeda.frameworks.synthetic.SyntheticFrameworkMethod;
import com.ibm.wala.andromeda.frameworks.synthetic.Variable;
import com.ibm.wala.andromeda.util.frameworks.FrameworkSignatureUtil;
import com.ibm.wala.andromeda.util.frameworks.MethodArgument;
import com.ibm.wala.andromeda.util.frameworks.MethodSignature;
import com.ibm.wala.andromeda.util.frameworks.SyntheticCodeCompiler;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.jstaint.util.scopes.ScopeUtil;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.util.io.CommandLine;
import com.ibm.wala.util.perf.Stopwatch;
import com.ibm.wala.util.strings.StringStuff;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;
import org.xml.sax.SAXException;

public class JavaCodeGenerator {
    private static final String SRC_DIR_NAME = "synt_src";
    private static final String ENTRYPOINTS_FILENAME = "FrameworkEntrypoints.txt";
    private static final String CALL_REPLACEMENTS_FILENAME = "CallSiteReplacements.txt";
    private static final String DEFAULT_PACKAGE_NAME = "Appscan";
    private static final String DEFAULT_CLASS_NAME = "Synthetic";
    private static final Logger logger = TaintLogger.i().getLogger();
    private IClassHierarchy cha;
    private String packageName;
    private String className;
    private SyntheticFrameworkClass sfc;

    public static void main(String[] args) throws IOException {
        Stopwatch sw = new Stopwatch();
        sw.start();
        try {
            JavaCodeGenerator.runMain(args);
        }
        catch (Throwable e) {
            System.exit(1);
        }
        sw.stop();
        FileWriter timeInfo = new FileWriter("code_gen_time.txt", true);
        timeInfo.write(sw.getElapsedMillis() + " ms\n");
        timeInfo.close();
    }

    public static void runMain(String[] args) throws Throwable {
        Properties parsedArgs = CommandLine.parse((String[])args);
        String inputFilename = parsedArgs.getProperty("input");
        if (inputFilename == null) {
            throw new IllegalArgumentException("input argument not present");
        }
        FrameworksInput input = FrameworksInput.make((String)inputFilename);
        FileLocations fileLocs = input.getFileLocs();
        String log4JConfigFile = fileLocs.getLogFileConfigName();
        DOMConfigurator.configure((String)log4JConfigFile);
        JavaCodeGenerator jcg = new JavaCodeGenerator();
        try {
            JavaFrameworkInfoGenerator.checkForRequiredOptions((FrameworksInput)input);
            jcg.generateWAFLJavaForJavaEEApp(fileLocs, input.getOptions());
        }
        catch (Throwable t) {
            TaintLogger.i().getLogger().fatal((Object)"uncaught exception", t);
            throw t;
        }
    }

    private void generateWAFLJavaForJavaEEApp(FileLocations fileLocs, Properties options) throws ClassHierarchyException, IOException, SAXException {
        this.genWAFLJavaforJavaEEApp(fileLocs.getScopeFileName(), fileLocs.getExclusionsFileName(), fileLocs.getWebContentDir(), options);
    }

    public void genWAFLJavaforJavaEEApp(String scopeFileName, String exclusionsFileName, String webContentDir, Properties options) throws ClassHierarchyException, IOException, SAXException {
        AnalysisScope scope;
        File exclusionsFile = exclusionsFileName == null ? null : new File(exclusionsFileName);
        try {
            scope = ScopeUtil.substituteAndCreateJavaAnalysisScope((String)scopeFileName, (File)exclusionsFile, (ClassLoader)WAFLSpecGen.class.getClassLoader());
        }
        catch (IOException e) {
            logger.fatal((Object)"IOException while reading scope file or exclusions file", (Throwable)e);
            throw e;
        }
        try {
            this.cha = ClassHierarchy.make((AnalysisScope)scope);
        }
        catch (ClassHierarchyException e) {
            logger.fatal((Object)"ClassHierarchyException while constructing class hierarchy", (Throwable)e);
            throw e;
        }
        IFrameworkInfo mergedFrameworkInfo = WAFLSpecGen.makeWithDefaultHandlers().getWAFLSpecForJavaEEApp(scope, this.cha, webContentDir, options);
        String outputDir = webContentDir;
        this.genJavaCode(scopeFileName, mergedFrameworkInfo, outputDir);
    }

    private boolean genJavaCode(String scopeFileName, IFrameworkInfo info, String outputDir) throws IOException {
        this.serializeEntrypoints(info);
        outputDir = outputDir + File.separator + SRC_DIR_NAME;
        JavaCodeGenerator.deleteFileOrDir(new File(outputDir));
        this.populateSyntheticClass(info, outputDir, scopeFileName);
        this.serializeCallReplacementMap(info, outputDir, scopeFileName);
        String fullOutputDirectory = outputDir + File.separator + this.packageName.replace(".", File.separator);
        File d = new File(fullOutputDirectory);
        d.mkdirs();
        String fullPathToOutputFile = fullOutputDirectory + File.separator + this.className + ".java";
        FileWriter fw = new FileWriter(new File(fullPathToOutputFile));
        fw.write(this.sfc.toJavaCode(this.cha));
        fw.close();
        boolean result = SyntheticCodeCompiler.compile(scopeFileName, outputDir, Collections.singletonList(fullPathToOutputFile));
        System.out.println("scope_file_addition: " + outputDir);
        return result;
    }

    public static boolean generateJavaCode(String scopeFileName, IFrameworkInfo info, String outputDir, IClassHierarchy cha) throws IOException {
        JavaCodeGenerator jcg = new JavaCodeGenerator();
        jcg.cha = cha;
        return jcg.genJavaCode(scopeFileName, info, outputDir);
    }

    private static boolean deleteFileOrDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = JavaCodeGenerator.deleteFileOrDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    private void serializeEntrypoints(IFrameworkInfo info) throws IOException {
        Set entrypointSignatures = info.getEntrypointSignatureToURLMappings().keySet();
        File f = new File(ENTRYPOINTS_FILENAME);
        f.delete();
        FileWriter fw = new FileWriter(ENTRYPOINTS_FILENAME);
        for (String sig : entrypointSignatures) {
            String modifiedSig = FrameworkSignatureUtil.dotsToSlashes(sig);
            int paramStartIndex = modifiedSig.indexOf(40);
            String method = FrameworkSignatureUtil.JVMTypeToJavaType(modifiedSig.substring(0, paramStartIndex));
            modifiedSig = method + modifiedSig.substring(paramStartIndex);
            fw.write(modifiedSig + "\n");
        }
        fw.close();
    }

    private void populateSyntheticClass(IFrameworkInfo info, String outputDir, String scopeFileName) {
        Set syntheticMethods = info.getSyntheticMethods();
        for (ISyntheticMethod sm : syntheticMethods) {
            String sig = VDBJavaUtil.vdb2JVMSignature((String)sm.getSignature());
            MethodSignature ms = FrameworkSignatureUtil.frameworksSigToMethodSignature(FrameworkSignatureUtil.dotsToSlashes(sig));
            SyntheticFrameworkMethod sfm = new SyntheticFrameworkMethod(ms, outputDir, scopeFileName);
            if (this.sfc == null) {
                this.packageName = ms.getPackageName();
                this.className = ms.getClassName();
                this.sfc = new SyntheticFrameworkClass(this.packageName, this.className);
            }
            this.sfc.addMethod(sfm);
            sfm.setGlobals(this.sfc.getVariables());
            for (BeanDecl b : sm.getLocalBeanDeclarations()) {
                sfm.addLocal(this.makeVariable(b));
            }
            sfm.addStatements(sm.getStatements());
        }
        if (this.sfc == null) {
            this.packageName = DEFAULT_PACKAGE_NAME;
            this.className = DEFAULT_CLASS_NAME;
            this.sfc = new SyntheticFrameworkClass(this.packageName, this.className);
        }
        for (BeanDecl b : info.getGlobalBeanDeclarations()) {
            this.sfc.addInstanceVariable(this.makeVariable(b));
        }
    }

    private Variable makeVariable(BeanDecl b) {
        String type = b.getType();
        if (type == null) {
            type = this.sfc.addInnerClass(b.getProperties(), b.getDynaBeanSupertypeName());
        }
        return new Variable(type, b.getId());
    }

    private void serializeCallReplacementMap(IFrameworkInfo info, String outputDir, String scopeFileName) throws IOException {
        File f = new File(CALL_REPLACEMENTS_FILENAME);
        f.delete();
        FileWriter fw = new FileWriter(CALL_REPLACEMENTS_FILENAME);
        StringBuilder sb = new StringBuilder();
        Map methodToReplacementsMapping = info.getMethodToReplacementsMapping();
        for (Map.Entry entry : methodToReplacementsMapping.entrySet()) {
            String vdbMethodSig = (String)entry.getKey();
            MethodReference mr = WalaUtil.getMethodRefFromVDBSig((String)vdbMethodSig);
            String callerSignature = mr.getSignature();
            for (CallSiteReplacement csRepl : (Set)entry.getValue()) {
                SyntheticExpr se = csRepl.getStatement();
                String targetSignature = VDBJavaUtil.vdb2JVMSignature((String)csRepl.getVdbMethodSig());
                MethodSignature ms = FrameworkSignatureUtil.frameworksSigToMethodSignature(FrameworkSignatureUtil.dotsToSlashes(targetSignature));
                int bytecodeIndex = csRepl.getBytecodeIndex();
                int lineNum = csRepl.getSrcLine();
                String synthMethodName = this.buildSynthMethodName(mr, ms, bytecodeIndex, lineNum);
                IMethod targetMethod = this.cha.resolveMethod(StringStuff.makeMethodReference((String)targetSignature));
                assert (targetMethod != null);
                List<MethodArgument> args = ms.getArgs();
                if (!targetMethod.isStatic()) {
                    ArrayList<MethodArgument> newArgs = new ArrayList<MethodArgument>();
                    MethodArgument receiver = new MethodArgument(ms.getFullyQualifiedClass(), "v0");
                    newArgs.add(receiver);
                    for (MethodArgument ma : args) {
                        String newVarName = "v" + String.valueOf(new Integer(ma.varName.substring(1)) + 1);
                        newArgs.add(new MethodArgument(ma.type, newVarName));
                    }
                    args = newArgs;
                }
                MethodSignature synthMS = new MethodSignature(ms.getReturnType(), this.packageName, this.className, synthMethodName, args);
                String serializedSynthSignature = synthMS.serializeToString();
                this.serialize(sb, callerSignature, targetSignature, bytecodeIndex, serializedSynthSignature);
                SyntheticFrameworkMethod sfm = new SyntheticFrameworkMethod(synthMS, outputDir, scopeFileName);
                sfm.setGlobals(this.sfc.getVariables());
                sfm.addReplacement(se);
                this.sfc.addMethod(sfm);
            }
        }
        fw.write(sb.toString());
        fw.close();
    }

    private void serialize(StringBuilder sb, String callerSignature, String targetSignature, int pc, String serializedSynthSignature) {
        sb.append(callerSignature);
        sb.append("\n");
        sb.append(pc);
        sb.append("\n");
        sb.append(targetSignature);
        sb.append("\n");
        sb.append(serializedSynthSignature);
        sb.append("\n");
    }

    public static String sanitizeJavaToken(String s) {
        return s.replace('[', '_').replace('.', '_').replace('/', '_').replace('<', '_').replace('>', '_').replace(';', '_').replace(',', '_').replace('(', '_').replace(')', '_').replace('-', '_');
    }

    private String buildSynthMethodName(MethodReference mr, MethodSignature ms, int pc, int lineNum) {
        StringBuilder sb = new StringBuilder();
        sb.append("__");
        sb.append(JavaCodeGenerator.sanitizeJavaToken(mr.getSignature()));
        sb.append("__");
        sb.append(JavaCodeGenerator.sanitizeJavaToken(ms.getPackageName()));
        sb.append("__");
        sb.append(ms.getClassName());
        sb.append("__");
        sb.append(JavaCodeGenerator.sanitizeJavaToken(ms.getMethodName()));
        sb.append("__");
        sb.append(pc);
        sb.append("__");
        sb.append(lineNum);
        return sb.toString();
    }
}

