/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.frameworks.synthetic;

import com.ibm.appscan.frameworks.specinfo.ArgToOrigCallExpr;
import com.ibm.appscan.frameworks.specinfo.AssignmentExpr;
import com.ibm.appscan.frameworks.specinfo.FormalParameterExpr;
import com.ibm.appscan.frameworks.specinfo.GlobalRefExpr;
import com.ibm.appscan.frameworks.specinfo.InvokeExpr;
import com.ibm.appscan.frameworks.specinfo.LocalRefExpr;
import com.ibm.appscan.frameworks.specinfo.NonDetSelectionExpr;
import com.ibm.appscan.frameworks.specinfo.NonVoidSyntheticExpr;
import com.ibm.appscan.frameworks.specinfo.ObjectRefExpr;
import com.ibm.appscan.frameworks.specinfo.StringConstantExpr;
import com.ibm.appscan.frameworks.specinfo.SyntheticExpr;
import com.ibm.appscan.frameworks.specinfo.TaintExpr;
import com.ibm.appscan.frameworks.util.VDBJavaUtil;
import com.ibm.wala.andromeda.frameworks.JavaCodeGenerator;
import com.ibm.wala.andromeda.frameworks.synthetic.Variable;
import com.ibm.wala.andromeda.util.frameworks.FrameworkSignatureUtil;
import com.ibm.wala.andromeda.util.frameworks.MethodArgument;
import com.ibm.wala.andromeda.util.frameworks.MethodSignature;
import com.ibm.wala.andromeda.util.frameworks.SyntheticCodeCompiler;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.strings.StringStuff;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SyntheticFrameworkMethod {
    private static final boolean DEBUG = false;
    private static final String RET_VAR = "__ret_var__";
    private static int count = 0;
    private final String outputDir;
    private final String scopeFileName;
    private final MethodSignature sig;
    private final Collection<SyntheticExpr> statements = HashSetFactory.make();
    private final Map<String, Variable> locals;
    private final Map<String, Variable> globals;
    private final Set<SyntheticExpr> replacements = HashSetFactory.make();

    private static String declareRetVarStmt(String type) {
        return type + " " + RET_VAR + " = null;";
    }

    private static String returnRetVarStmt() {
        return "return __ret_var__;";
    }

    public MethodSignature getSignature() {
        return this.sig;
    }

    public SyntheticFrameworkMethod(MethodSignature sig, String outputDir, String scopeFileName) {
        this.locals = HashMapFactory.make();
        this.globals = HashMapFactory.make();
        this.sig = sig;
        this.outputDir = outputDir;
        this.scopeFileName = scopeFileName;
    }

    public void setGlobals(Collection<Variable> globals) {
        for (Variable v : globals) {
            this.globals.put(v.getID(), v);
        }
    }

    public void addLocal(Variable iv) {
        this.locals.put(iv.getID(), iv);
    }

    public void addStatements(Collection<SyntheticExpr> statements) {
        this.statements.addAll(statements);
    }

    public void addReplacement(SyntheticExpr se) {
        this.replacements.add(se);
    }

    public String toString() {
        Assertions.UNREACHABLE((String)"You need a cha to print out the java code");
        return null;
    }

    private boolean shouldPrintRetVal(String retType) {
        return this.replacements.size() > 0 && !retType.equals("void");
    }

    public String toJavaCode(String indent, IClassHierarchy cha) throws IOException {
        String s;
        StringBuilder sb = new StringBuilder();
        sb.append(indent);
        sb.append("public static ");
        sb.append(this.sig.getDeclString());
        sb.append(" {\n");
        String newIndent = indent + "    ";
        String retType = this.sig.getReturnType();
        if (this.shouldPrintRetVal(retType)) {
            sb.append(newIndent);
            sb.append(SyntheticFrameworkMethod.declareRetVarStmt(retType));
            sb.append("\n");
        }
        sb.append(newIndent);
        sb.append("try {\n");
        newIndent = newIndent + "    ";
        for (Variable iv : this.locals.values()) {
            sb.append(iv.toJavaCodeForLocal(newIndent));
            sb.append("\n");
        }
        for (SyntheticExpr e : this.statements) {
            assert (e instanceof AssignmentExpr || e instanceof InvokeExpr);
            s = this.callToJavaExpression(e, newIndent, cha);
            sb.append(s);
            sb.append(";\n");
        }
        for (SyntheticExpr e : this.replacements) {
            s = this.callToJavaExpression(e, newIndent, cha);
            sb.append(s);
            sb.append(";\n");
        }
        newIndent = indent + "    ";
        sb.append(newIndent);
        sb.append("} catch (Throwable t) { }\n");
        if (this.shouldPrintRetVal(retType)) {
            sb.append(newIndent);
            sb.append(SyntheticFrameworkMethod.returnRetVarStmt());
            sb.append("\n");
        }
        sb.append(indent);
        sb.append("}");
        return sb.toString();
    }

    private String callToJavaExpression(SyntheticExpr e, String indent, IClassHierarchy cha) throws IOException {
        if (e instanceof AssignmentExpr) {
            return indent + this.toJavaExpressionAssignmentExpr((AssignmentExpr)e, cha);
        }
        if (e instanceof InvokeExpr) {
            return indent + this.toJavaExpressionInvokeExpr((InvokeExpr)e, cha);
        }
        if (e instanceof ObjectRefExpr) {
            return indent + this.toJavaExpressionObjectRefExpr((ObjectRefExpr)e, cha);
        }
        if (e instanceof FormalParameterExpr) {
            return indent + this.toJavaExpressionFormalParameter((FormalParameterExpr)e);
        }
        if (e instanceof GlobalRefExpr) {
            return indent + this.toJavaExpressionGlobalRefExpr((GlobalRefExpr)e);
        }
        if (e instanceof LocalRefExpr) {
            return indent + this.toJavaExpressionLocalRef((LocalRefExpr)e);
        }
        if (e instanceof StringConstantExpr) {
            return indent + this.toJavaExpressionStringConstantExpr((StringConstantExpr)e);
        }
        if (e instanceof TaintExpr) {
            return indent + this.toJavaExpressionTaintExpr((TaintExpr)e);
        }
        if (e instanceof ArgToOrigCallExpr) {
            return indent + this.toJavaExpressionArgToOrigCallExpr((ArgToOrigCallExpr)e);
        }
        if (e instanceof NonDetSelectionExpr) {
            return indent + this.toJavaExpressionNonDetSelectionExpr((NonDetSelectionExpr)e, cha);
        }
        Assertions.UNREACHABLE((String)("Did not get a sub type that we expected: " + e.getClass()));
        return null;
    }

    private String toJavaExpressionNonDetSelectionExpr(NonDetSelectionExpr e, IClassHierarchy cha) throws IOException {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (SyntheticExpr expr : e.getExpressions()) {
            sb.append("(i == " + i + "?" + this.callToJavaExpression(expr, "   ", cha) + ":");
            ++i;
        }
        sb.append("null");
        while (i > 0) {
            sb.append(")");
            --i;
        }
        return sb.toString();
    }

    private String toJavaExpressionTaintExpr(TaintExpr e) {
        String servletRequestParamName = this.sig.getServletRequestParamName();
        StringBuilder sb = new StringBuilder();
        if (servletRequestParamName == null) {
            servletRequestParamName = "(new Serv(null))";
        }
        sb.append(servletRequestParamName);
        sb.append(".getParameter(\"");
        sb.append(e.getParameterName());
        sb.append("\")");
        return sb.toString();
    }

    private static String getVariableType(String id, Map<String, Variable> vars) {
        Variable v = vars.get(id);
        if (v != null) {
            return v.getType();
        }
        return null;
    }

    private String toJavaExpressionAssignmentExpr(AssignmentExpr e, IClassHierarchy cha) throws IOException {
        StringBuilder sb = new StringBuilder();
        String lhs = this.callToJavaExpression((SyntheticExpr)e.getLval(), "", cha);
        sb.append(lhs);
        sb.append(" = ");
        String type = null;
        type = SyntheticFrameworkMethod.getVariableType(lhs, this.locals);
        if (type == null) {
            type = SyntheticFrameworkMethod.getVariableType(lhs, this.globals);
        }
        if (type != null) {
            sb.append('(');
            sb.append(type);
            sb.append(") ");
        }
        sb.append(this.callToJavaExpression((SyntheticExpr)e.getRval(), "", cha));
        return sb.toString();
    }

    private String toJavaExpressionInvokeExpr(InvokeExpr e, IClassHierarchy cha) throws IOException {
        IClassLoader cl;
        TypeReference tr;
        MethodReference mr;
        MethodSignature calleeSig = FrameworkSignatureUtil.frameworksSigToMethodSignature(FrameworkSignatureUtil.dotsToSlashes(VDBJavaUtil.vdb2JVMSignature((String)e.getCalleeVDBSignature())));
        Map actualParameterPos2Value = e.getActualParameterPos2Value();
        String fullyQualifiedClassJVM = calleeSig.getFullyQualifiedClassJVM();
        String methodName = calleeSig.getMethodName();
        String descriptorJVM = calleeSig.getDescriptorJVM();
        IMethod m = null;
        IClassLoader[] iClassLoaderArray = cha.getLoaders();
        int n = iClassLoaderArray.length;
        for (int i = 0; i < n && (m = cha.resolveMethod(mr = MethodReference.findOrCreate((TypeReference)(tr = TypeReference.findOrCreate((ClassLoaderReference)(cl = iClassLoaderArray[i]).getReference(), (String)fullyQualifiedClassJVM)), (String)methodName, (String)descriptorJVM))) == null; ++i) {
        }
        if (m == null) {
            System.err.println("couldn't find IMethod for: " + fullyQualifiedClassJVM + "/" + methodName + descriptorJVM);
        }
        HashMap actuals = HashMapFactory.make();
        for (Map.Entry entry : actualParameterPos2Value.entrySet()) {
            String javaCode = this.callToJavaExpression((SyntheticExpr)entry.getValue(), "", cha);
            String declaredTypeOfFormal = !m.isStatic() && (Integer)entry.getKey() == 0 ? calleeSig.getFullyQualifiedClass() : calleeSig.getArgs().get((int)(((Integer)entry.getKey()).intValue() - (m.isStatic() ? 0 : 1))).type;
            if (this.isDownCastNeeded(declaredTypeOfFormal, (NonVoidSyntheticExpr)entry.getValue(), cha)) {
                javaCode = "((" + declaredTypeOfFormal.replace('$', '.') + ")" + javaCode + ")";
            }
            actuals.put(entry.getKey(), javaCode);
        }
        if (m == null) {
            return calleeSig.getCallString(actuals, true, false);
        }
        boolean isClassAbstract = m.getDeclaringClass().isAbstract();
        if (!m.isPublic()) {
            return this.createAuxiliaryCode(calleeSig, actuals, methodName, m.isStatic(), isClassAbstract);
        }
        return calleeSig.getCallString(actuals, m.isStatic(), isClassAbstract);
    }

    private boolean isDownCastNeeded(String expectedType, NonVoidSyntheticExpr actualExpr, IClassHierarchy cha) {
        if (expectedType.equals("java.lang.Object")) {
            return false;
        }
        if (actualExpr instanceof NonDetSelectionExpr) {
            return true;
        }
        if (actualExpr instanceof ObjectRefExpr) {
            actualExpr = ((ObjectRefExpr)actualExpr).getRef();
        }
        if (actualExpr instanceof NonDetSelectionExpr) {
            return true;
        }
        String typeOfActual = null;
        if (actualExpr instanceof InvokeExpr) {
            InvokeExpr invoke = (InvokeExpr)actualExpr;
            MethodSignature calleeSig = FrameworkSignatureUtil.frameworksSigToMethodSignature(FrameworkSignatureUtil.dotsToSlashes(VDBJavaUtil.vdb2JVMSignature((String)invoke.getCalleeVDBSignature())));
            typeOfActual = calleeSig.getReturnType();
        } else {
            String id = null;
            if (actualExpr instanceof GlobalRefExpr) {
                id = ((GlobalRefExpr)actualExpr).getId();
            }
            if (actualExpr instanceof LocalRefExpr) {
                id = ((LocalRefExpr)actualExpr).getId();
            }
            if (id == null) {
                return false;
            }
            typeOfActual = SyntheticFrameworkMethod.getVariableType(id = id.replace(".", "_"), this.locals);
            if (typeOfActual == null) {
                typeOfActual = SyntheticFrameworkMethod.getVariableType(id, this.globals);
            }
        }
        if (typeOfActual.equals("java.lang.Object")) {
            return true;
        }
        if (typeOfActual.equals(expectedType)) {
            return false;
        }
        IClass expectedClass = cha.lookupClass(TypeReference.findOrCreate((ClassLoaderReference)ClassLoaderReference.Application, (String)StringStuff.deployment2CanonicalTypeString((String)expectedType)));
        IClass foundClass = cha.lookupClass(TypeReference.findOrCreate((ClassLoaderReference)ClassLoaderReference.Application, (String)StringStuff.deployment2CanonicalTypeString((String)typeOfActual)));
        if (expectedClass == null || foundClass == null) {
            return true;
        }
        return !cha.isAssignableFrom(expectedClass, foundClass);
    }

    private String createAuxiliaryCode(MethodSignature calleeSig, Map<Integer, String> actuals, String methodName, boolean isStatic, boolean isClassAbstract) throws IOException {
        String indent = "  ";
        String packageName = calleeSig.getPackageName();
        String fullOutputDirectory = this.outputDir + File.separator + packageName.replace(".", File.separator);
        File d = new File(fullOutputDirectory);
        d.mkdirs();
        String className = calleeSig.getClassName();
        String auxClassName = className + "__" + ++count;
        String fullPathToOutputFile = fullOutputDirectory + File.separator + auxClassName + ".java";
        MethodSignature auxMethodSig = new MethodSignature(calleeSig.getReturnType(), packageName, auxClassName, methodName, calleeSig.getArgs());
        StringBuilder sb = new StringBuilder();
        sb.append("package ");
        sb.append(packageName);
        sb.append(";\n");
        sb.append("public class ");
        sb.append(auxClassName);
        sb.append(" {\n");
        sb.append("  ");
        sb.append("public ");
        if (isStatic) {
            sb.append("static ");
        }
        sb.append(auxMethodSig.getDeclString());
        sb.append(" throws Exception {\n");
        sb.append("  ");
        sb.append("  ");
        if (!calleeSig.getReturnType().equals("void")) {
            sb.append("return ");
        }
        List<MethodArgument> args = auxMethodSig.getArgs();
        sb.append(this.getAuxiliaryCallString(args, className, methodName, isStatic));
        sb.append(";\n");
        sb.append("  ");
        sb.append("}\n}");
        FileWriter fw = new FileWriter(new File(fullPathToOutputFile));
        fw.write(sb.toString());
        fw.close();
        boolean success = SyntheticCodeCompiler.compile(this.scopeFileName, this.outputDir, Collections.singletonList(fullPathToOutputFile));
        assert (success) : "compile failed";
        return auxMethodSig.getCallString(actuals, isStatic, isClassAbstract);
    }

    public String getAuxiliaryCallString(List<MethodArgument> args, String className, String methodName, boolean isStatic) {
        StringBuilder sb = new StringBuilder();
        if (isStatic) {
            sb.append(className);
            sb.append('.');
        } else {
            sb.append("(new ");
            sb.append(className);
            sb.append("())");
            sb.append('.');
        }
        sb.append(methodName);
        sb.append('(');
        for (int i = 0; i < args.size(); ++i) {
            MethodArgument a = args.get(i);
            sb.append(a.varName);
            if (i + 1 >= args.size()) continue;
            sb.append(", ");
        }
        sb.append(')');
        return sb.toString();
    }

    private String toJavaExpressionObjectRefExpr(ObjectRefExpr e, IClassHierarchy cha) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(this.callToJavaExpression((SyntheticExpr)e.getRef(), "", cha));
        String accessPath = e.getAccessPath();
        if (!accessPath.equals("")) {
            sb.append(".");
            sb.append(accessPath);
        }
        return sb.toString();
    }

    private String toJavaExpressionFormalParameter(FormalParameterExpr e) {
        StringBuilder sb = new StringBuilder();
        sb.append("v");
        sb.append(e.getParameterPos());
        return sb.toString();
    }

    private String toJavaExpressionGlobalRefExpr(GlobalRefExpr e) {
        return JavaCodeGenerator.sanitizeJavaToken(e.getId());
    }

    private String toJavaExpressionLocalRef(LocalRefExpr e) {
        return JavaCodeGenerator.sanitizeJavaToken(e.getId());
    }

    private String toJavaExpressionStringConstantExpr(StringConstantExpr e) {
        StringBuilder sb = new StringBuilder();
        sb.append("\"");
        sb.append(e.getValue());
        sb.append("\"");
        return sb.toString();
    }

    public String toJavaExpressionArgToOrigCallExpr(ArgToOrigCallExpr e) {
        int index = e.getPos();
        if (index == -1) {
            return RET_VAR;
        }
        return "v" + index;
    }
}

