/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.common.eclipse.handlers;

import com.ibm.appscan.common.eclipse.handlers.ProjectHandler;
import java.io.File;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class JavaProjectHandler
extends ProjectHandler {
    private IJavaProject m_javaProject;

    public JavaProjectHandler(String project) {
        super(project);
        this.m_javaProject = JavaCore.create((IWorkspaceRoot)this.m_root).getJavaProject(project);
    }

    @Override
    public String getOutputDir() throws JavaModelException {
        return this.getOutputDir(this.m_javaProject);
    }

    private String getOutputDir(IJavaProject project) throws JavaModelException {
        String strOutPutDir = this.m_root.getFolder(project.getOutputLocation()).getLocation().toOSString();
        for (IClasspathEntry entry : project.getResolvedClasspath(false)) {
            String[] sourcePath;
            if (entry.getEntryKind() != 3 || Arrays.asList(sourcePath = entry.getPath().segments()).contains("test") || entry.getOutputLocation() == null) continue;
            strOutPutDir = strOutPutDir + ";" + this.m_root.getFolder(entry.getOutputLocation()).getLocation().toOSString();
        }
        return strOutPutDir;
    }

    @Override
    public String getSourceRoots() throws JavaModelException {
        String srcRoots = "";
        for (IClasspathEntry entry : this.m_javaProject.getResolvedClasspath(false)) {
            if (entry.getEntryKind() != 3) continue;
            srcRoots = srcRoots + this.m_root.getFolder(entry.getPath()).getLocation().toOSString() + ";";
        }
        if (srcRoots.endsWith(File.pathSeparator)) {
            srcRoots = srcRoots.substring(0, srcRoots.length() - 1);
        }
        return srcRoots;
    }

    public String getClasspath() throws JavaModelException, CoreException {
        String classpath = "";
        for (String entry : this.getClasspathEntries(this.m_javaProject.getRawClasspath(), true)) {
            classpath = classpath + entry + File.pathSeparator;
        }
        return classpath + this.getOutputDir() + File.pathSeparator;
    }

    private Set<String> getClasspathEntries(IClasspathEntry[] entries, boolean processProjects) throws JavaModelException, CoreException {
        LinkedHashSet<String> classpath = new LinkedHashSet<String>();
        block7: for (IClasspathEntry entry : entries) {
            switch (entry.getEntryKind()) {
                case 3: {
                    if (entry.getOutputLocation() == null) continue block7;
                    classpath.add(this.m_root.getFolder(entry.getOutputLocation()).getLocation().toOSString());
                    continue block7;
                }
                case 2: {
                    IJavaProject project;
                    if (!processProjects || (project = JavaCore.create((IWorkspaceRoot)this.m_root).getJavaProject(entry.getPath().toOSString())) == null) continue block7;
                    project.open(null);
                    classpath.add(this.getOutputDir(project));
                    classpath.addAll(this.getClasspathEntries(project.getRawClasspath(), false));
                    continue block7;
                }
                case 4: {
                    IClasspathEntry resolved = JavaCore.getResolvedClasspathEntry((IClasspathEntry)entry);
                    if (resolved == null) continue block7;
                    classpath.add(resolved.getPath().toOSString());
                    continue block7;
                }
                case 1: {
                    if (!entry.getPath().toFile().exists()) {
                        IResource resource = this.m_root.findMember(entry.getPath());
                        if (resource == null) continue block7;
                        classpath.add(resource.getLocation().toOSString());
                        continue block7;
                    }
                    classpath.add(entry.getPath().toOSString());
                    continue block7;
                }
                case 5: {
                    IClasspathContainer container;
                    if (!processProjects || (container = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)this.m_javaProject)) == null || container.getPath().toString().contains("JRE_CONTAINER") || container.getPath().toString().contains("JUNIT_CONTAINER")) continue block7;
                    classpath.addAll(this.getClasspathEntries(container.getClasspathEntries(), true));
                    continue block7;
                }
            }
        }
        return classpath;
    }

    public String getJDK() throws CoreException {
        IVMInstall install = JavaRuntime.getVMInstall((IJavaProject)this.m_javaProject);
        if (install != null && install.getInstallLocation() != null) {
            return install.getInstallLocation().getAbsolutePath();
        }
        return "";
    }

    public String getWebContent() {
        IVirtualComponent component;
        String webContent = "";
        if (Platform.getBundle((String)"org.eclipse.wst.common.modulecore") != null && (component = ComponentCore.createComponent((IProject)this.m_javaProject.getProject())) != null && component.exists()) {
            webContent = component.getRootFolder().getUnderlyingFolder().getLocation().toOSString();
        }
        return webContent;
    }
}

