using System;
using System.Collections.Generic;
using System.Text;

namespace Common
{
    public class ExceptionEntry : MarshalByRefObject
    {
        #region Fields
        private readonly String handlerKind;
        private readonly int catchTypeToken;
        private readonly int tryStart;
        private readonly int tryLength;
        private readonly int filterStart;
        private readonly int handlerStart;
        private readonly int handlerLength;
        #endregion

        #region CTOR(s)
        public ExceptionEntry(String handlerKind, int catchTypeToken, int tryStart, int tryLength, 
            int filterStart, int handlerStart, int handlerLength)
        {
            this.handlerKind    = handlerKind;
            this.catchTypeToken = catchTypeToken;
            this.tryStart       = tryStart;
            this.tryLength      = tryLength;
            this.filterStart    = filterStart;
            this.handlerStart   = handlerStart;
            this.handlerLength  = handlerLength;
        }
        #endregion

        #region Properties
        public int CatchTypeToken
        {
            get { return catchTypeToken; }
        }

        public int TryStart
        {
            get { return tryStart; }
        }

        public int FilterStart
        {
            get { return filterStart; }
        }

        public int TryLength
        {
            get { return tryLength; }
        }

        public int HandlerStart
        {
            get { return handlerStart; }
        }

        public String HandlerKind
        {
            get { return handlerKind; }
        }

        public int HandlerLength
        {
            get { return handlerLength; }
        }
        #endregion
    }
}
