@echo off

@REM ----------------------------------------------------------------------------
@REM  Static Analyzer script for Windows
@REM ----------------------------------------------------------------------------

@REM ----------------------------------------------------------------------------
@REM THIS PRODUCT CONTAINS RESTRICTED MATERIALS OF HCL
@REM AppScan on Cloud (C) COPYRIGHT HCL Technologies, 2016, 2025
@REM All Rights Reserved * Licensed Materials - Property of HCL
@REM US Government Users Restricted Rights - Use, duplication or disclosure
@REM restricted by GSA ADP Schedule Contract with HCL Technologies. 
@REM ----------------------------------------------------------------------------

@REM ----------------------------------------------------------------------------
@REM ENVIRONMENT VARIABLES
@REM
@REM Optional:
@REM 	APPSCAN_OPTS - Parameters passed to the Java JVM
@REM 		e.g. To enable FIPS for HCL SDK use:
@REM			set APPSCAN_OPTS=-Dcom.ibm.jsse2.usefipsprovider=true
@REM ----------------------------------------------------------------------------

if defined APPSCAN_INTERNAL (
	set APPSCAN_OPTS=%APPSCAN_OPTS% -DINTERNAL_SERVER=%APPSCAN_INTERNAL%
	echo .
	echo WARNING: The APPSCAN_INTERNAL environment variable has been replaced with the Java property -DINTERNAL_SERVER.
	echo e.g. set APPSCAN_OPTS=-DINTERNAL_SERVER=^<server^>
	echo .
)
if defined APPSCAN_DOMAIN (
	set APPSCAN_OPTS=%APPSCAN_OPTS% -DBLUEMIX_SERVER=%APPSCAN_DOMAIN%
	echo .
	echo WARNING: The APPSCAN_DOMAIN environment variable has been replaced with the Java property -DBLUEMIX_SERVER.
	echo e.g. set APPSCAN_OPTS=-DBLUEMIX_SERVER=^<server^>
	echo .
)

:checkIRGenClientName
@rem Check for APPSCAN_IRGEN_CLIENT
if defined APPSCAN_IRGEN_CLIENT goto checkJavaHome
set APPSCAN_IRGEN_CLIENT=CLI

:checkJavaHome
@rem Check for JAVA_HOME
if defined JAVA_HOME goto execute
set JAVA_HOME=%~dp0..\jre

:execute
@rem Setup the command line
set APPSCAN_INSTALL_DIR=%~dp0..
set APPSCAN_CLI_CLASSPATH=%APPSCAN_INSTALL_DIR%\lib\*;
set JAVA_EXE=%APPSCAN_INSTALL_DIR%\jre\bin\java.exe
set APPSCAN_INSTALLER_TEMP=%USERPROFILE%\.appscan\temp

@rem Process additional configuration
setlocal EnableExtensions EnableDelayedExpansion
IF EXIST "%APPSCAN_INSTALL_DIR%\config\cli.config" (
	for /F "usebackq delims=" %%a in ("%APPSCAN_INSTALL_DIR%\config\cli.config") do set APPSCAN_JVM_CONFIG_PROPS=!APPSCAN_JVM_CONFIG_PROPS! %%a
)
endlocal & set CLI_CONFIG_OPTS=%APPSCAN_JVM_CONFIG_PROPS%

@rem Execute AppScan CLI
if "x%~1"=="x" goto showHelp
if "%~1"=="update" goto doUpdate
goto executeCommand

:doUpdate
@rem Check if install directory is writable.
dir "%APPSCAN_INSTALL_DIR%" > "%APPSCAN_INSTALL_DIR%"\.appscan123
if %ERRORLEVEL% NEQ 0 (
 echo WARNING: Unable to proceed with the command.  Please check if the directory is writable.
 goto endExecution
)
del /Q "%APPSCAN_INSTALL_DIR%"\.appscan123

@rem Create product temp folders if doesn't exist
IF NOT EXIST "%USERPROFILE%\.appscan" (
	mkdir "%USERPROFILE%\.appscan"
)

IF NOT EXIST "%APPSCAN_INSTALLER_TEMP%" (
	mkdir "%APPSCAN_INSTALLER_TEMP%"
)

"%JAVA_EXE%" --module-path "%APPSCAN_INSTALL_DIR%\fips" --add-opens java.base/java.security=ALL-UNNAMED --add-exports java.base/sun.security.internal.spec=ALL-UNNAMED  %CLI_CONFIG_OPTS% %APPSCAN_OPTS% -cp "%APPSCAN_CLI_CLASSPATH%" com.ibm.appscan.cli.common.Launcher "%APPSCAN_INSTALL_DIR%" update

if %ERRORLEVEL% NEQ 0 (
	goto fail
)

cd "%APPSCAN_INSTALL_DIR%"\..
for /f "delims=" %%q in ("%~dp0..") do set TEMP_DIR=%%~nxq

@rem Check if this is a name with version number in it
set stdName=%TEMP_DIR:~-5%
set hasVersion="false"
echo %stdName% | findstr /r "[0-9]" >nul

IF %errorlevel% EQU 0 (
    set hasVersion="true"
)

IF %hasVersion%=="true" (
	IF "%TEMP_DIR:~0,12%"=="SAClientUtil" (
		goto setStdName
	)
) ELSE (
	goto setNonStdName
)

:setStdName
	set INSTALL_FOLDER=%TEMP_DIR:~0,12%
	set INSTALL_PATH=%~dp0..\..\
	set ORIG_INSTALL_DRIVE=%APPSCAN_INSTALL_DIR:~0,2%
	@rem format new install path
	call set UPDATE_DIR="%ORIG_INSTALL_DRIVE%%%%INSTALL_PATH%%INSTALL_FOLDER%%%"
	goto proceed
	
:setNonStdName
	set UPDATE_DIR="%APPSCAN_INSTALL_DIR%"

:proceed
@rem Change directory to Appscan install temp directory to run the cleanup script from there
cd /D %APPSCAN_INSTALLER_TEMP%
IF EXIST %APPSCAN_INSTALLER_TEMP%\cleanup-appscan.bat  (
	del /F /Q %APPSCAN_INSTALLER_TEMP%\cleanup-appscan.bat
)

@rem Create cleanup script in temp directory
echo @echo off > cleanup-appscan.bat
echo set APPSCAN_INSTALL_DIR=%APPSCAN_INSTALL_DIR% >>cleanup-appscan.bat
echo set NEW_INSTALL_DIR=%UPDATE_DIR% >>cleanup-appscan.bat
echo set INSTALL_DRIVE=%CD:~0,2% >>cleanup-appscan.bat
echo. >>cleanup-appscan.bat
@rem In case we are running from a drive other than C:, go to C: drive explicitly and then
@rem preserve the drive info so we can switch back to it later
echo if NOT "%%CD:~0,3%%" == "C:\" (set INSTALL_DRIVE=%%CD:~0,2%% ^& C:) >>cleanup-appscan.bat
echo. >>cleanup-appscan.bat
echo IF EXIST %%APPSCAN_INSTALLER_TEMP%%\SAClientUtil\version.info ( >>cleanup-appscan.bat
echo 	IF EXIST %%APPSCAN_INSTALLER_TEMP%%\SAClientUtil.zip ( >>cleanup-appscan.bat
echo 		robocopy /move /E /NFL /NDL "%APPSCAN_INSTALL_DIR%" %%APPSCAN_INSTALLER_TEMP%%\appscan_old  ^>NUL >>cleanup-appscan.bat
echo 		del /F /Q %%APPSCAN_INSTALLER_TEMP%%\SAClientUtil.zip >>cleanup-appscan.bat
echo  		goto moveDir  >>cleanup-appscan.bat
echo 	) >>cleanup-appscan.bat
echo ) ELSE ( >>cleanup-appscan.bat
echo cd %APPSCAN_INSTALL_DIR%\bin >>cleanup-appscan.bat
echo exit /b 1  >>cleanup-appscan.bat
echo ) >>cleanup-appscan.bat
echo :moveDir  >>cleanup-appscan.bat
echo TIMEOUT 5 ^>NUL >>cleanup-appscan.bat
echo robocopy /move /E /NFL /NDL %%APPSCAN_INSTALLER_TEMP%%\SAClientUtil  %%NEW_INSTALL_DIR%%  ^>NUL >>cleanup-appscan.bat
echo. >>cleanup-appscan.bat
echo IF %errorlevel% EQU 0 ( >>cleanup-appscan.bat
echo 	goto updateSuccess  >>cleanup-appscan.bat
echo ) ELSE ( >>cleanup-appscan.bat
echo 	goto updateFail >>cleanup-appscan.bat
echo ) >>cleanup-appscan.bat
echo. >>cleanup-appscan.bat
echo :updateFail >>cleanup-appscan.bat
echo IF EXIST %%APPSCAN_INSTALLER_TEMP%%\SAClientUtil ( >>cleanup-appscan.bat
echo 	rmdir /s /q %%APPSCAN_INSTALLER_TEMP%%\SAClientUtil >>cleanup-appscan.bat
echo ) >>cleanup-appscan.bat
echo IF EXIST %%APPSCAN_INSTALLER_TEMP%%\appscan_old ( >>cleanup-appscan.bat
echo 	robocopy /move /E /NFL /NDL %%APPSCAN_INSTALLER_TEMP%%\appscan_old "%APPSCAN_INSTALL_DIR%" ^>NUL  >>cleanup-appscan.bat
echo ) >>cleanup-appscan.bat
echo echo. >>cleanup-appscan.bat
echo echo Update failed.  >>cleanup-appscan.bat
echo %%ORIG_INSTALL_DRIVE%% >>cleanup-appscan.bat
echo goto endCleanUp  >>cleanup-appscan.bat
echo. >>cleanup-appscan.bat
echo :updateSuccess >>cleanup-appscan.bat
echo rmdir /s /q %%APPSCAN_INSTALLER_TEMP%%\appscan_old >>cleanup-appscan.bat
echo echo. >>cleanup-appscan.bat
echo echo Update complete.  >>cleanup-appscan.bat
echo %%ORIG_INSTALL_DRIVE%% >>cleanup-appscan.bat
echo cd /D %%NEW_INSTALL_DIR%% >>cleanup-appscan.bat
echo echo New version is located at:  %%CD%% >>cleanup-appscan.bat
echo. >>cleanup-appscan.bat
echo :endCleanUp  >>cleanup-appscan.bat
echo exit /b 1 >>cleanup-appscan.bat

TIMEOUT 2 >NUL
%APPSCAN_INSTALLER_TEMP%\cleanup-appscan.bat

:executeCommand
"%JAVA_EXE%" -Xmx8g --module-path "%APPSCAN_INSTALL_DIR%\fips" --add-opens java.base/java.security=ALL-UNNAMED --add-exports java.base/sun.security.internal.spec=ALL-UNNAMED %CLI_CONFIG_OPTS% %APPSCAN_OPTS% -cp "%APPSCAN_CLI_CLASSPATH%" com.ibm.appscan.cli.common.Launcher "%APPSCAN_INSTALL_DIR%" %*
goto endExecution

:showHelp
"%JAVA_EXE%" %CLI_CONFIG_OPTS% %APPSCAN_OPTS% -cp "%APPSCAN_CLI_CLASSPATH%" com.ibm.appscan.cli.common.Launcher "%APPSCAN_INSTALL_DIR%" help
goto endExecution

:fail
exit /b 1

:endExecution
exit /B "%ERRORLEVEL%"
ENDLOCAL
