using System;
using System.Collections.Generic;
using System.Text;
using System.Reflection.Emit;
using System.Reflection;

namespace CSharp
{
    public abstract class ILInstruction
    {
        private readonly OpCode opcode;
        private readonly Int32 offset;
        private readonly MethodBase enclosingMethod;

        protected ILInstruction(MethodBase enclosingMethod, OpCode opcode, Int32 offset)
        {
            this.opcode             = opcode;
            this.offset             = offset;
            this.enclosingMethod    = enclosingMethod;
        }

        public override String ToString()
        {
            const int MAX_OFFSET_LABEL_LENGTH = 4;
            StringBuilder sb = new StringBuilder("IL_");
            String hexOffsetStr = Convert.ToString(offset, 16);
            for (int index = 0; index < (MAX_OFFSET_LABEL_LENGTH - hexOffsetStr.Length); ++index)
            {
                sb.Append('0');
            }
            sb.Append(hexOffsetStr);
            sb.Append(": [");
            sb.Append(enclosingMethod);
            sb.Append("] ");
            sb.Append(opcode);
            return sb.ToString();
        }

        public OpCode Opcode
        {
            get
            {
                return this.opcode;
            }
        }

        public Int32 Offset
        {
            get
            {
                return this.offset;
            }
        }

        public MethodBase EnclosingMethodBody
        {
            get
            {
                return this.enclosingMethod;
            }
        }
    }
}
