using System;
using System.Collections.Generic;
using System.Text;
using System.Reflection.Emit;
using System.Reflection;

namespace CSharp
{
    class InlineMethodInstruction : ILInstruction
    {
        private readonly Int32 metadata;
        private readonly MethodBase target;

        public InlineMethodInstruction(MethodBase enclosingMethod, OpCode opcode, Int32 offset, Int32 metadata)
            : base(enclosingMethod, opcode, offset)
        {
            this.metadata   = metadata;
            try
            {
                this.target = TryResolveTarget(enclosingMethod, enclosingMethod.DeclaringType.GetGenericArguments(), enclosingMethod.GetGenericArguments());
            }
            catch (System.NotSupportedException)
            { 
            }
            try
            {
                if (this.target == null)
                {
                    this.target = TryResolveTarget(enclosingMethod, enclosingMethod.DeclaringType.GetGenericArguments(), new Type[0]);
                }
            }
            catch (System.NotSupportedException)
            { 
            }
            try
            {
                if (this.target == null)
                {
                    this.target = TryResolveTarget(enclosingMethod, new Type[0], new Type[0]);
                }
            }
            catch (System.NotSupportedException)
            { 
            }
            //System.Diagnostics.Debug.Assert(false);
        }

        private System.Reflection.MethodBase TryResolveTarget(System.Reflection.MethodBase method, Type[] typeGenericArgs, Type[] methodGenericArgs)
        {
            try
            {
                return method.Module.ResolveMethod(this.metadata, typeGenericArgs, methodGenericArgs);
            }
            catch (System.ArgumentException ex)
            {
                Console.WriteLine(ex);
            }
            catch (System.BadImageFormatException ex)
            {
                Console.WriteLine(ex);
            }
            catch (System.NotSupportedException ex)
            {
                Console.WriteLine(ex);
            }
            return null;
        }

        public override string ToString()
        {
            StringBuilder sb = new StringBuilder(base.ToString());
            sb.Append('\t');
            sb.Append(target);
            return sb.ToString();
        }

        public Int32 Metadata
        {
            get
            {
                return this.metadata;
            }
        }

        public MethodBase Target
        {
            get 
            { 
                return this.target; 
            }
        } 
    }
}
