using System;

namespace Common
{
    public interface IDriver
    {
        int ArrayGetElement(int arrayClsIndex);
        int AttributeGetType(int attIndex);
		int AttributeArgumentCount(int attIndex);
		int AttributeArgumentType(int attIndex, int argIndex);
		string AttributeArgumentValue(int attIndex, int argIndex);
        int[] ClassGetCustomAttributes(int clsIndex);
        int[] ClassGetDeclaredInstanceFields(int clsIndex);
        int[] ClassGetDeclaredInstanceMethods(int clsIndex);
        int[] ClassGetDeclaredInterfaces(int clsIndex);
        int[] ClassGetDeclaredStaticFields(int clsIndex);
        int[] ClassGetDeclaredStaticMethods(int clsIndex);
        int ClassGetImage(int clsIndex);
        string ClassGetName(int clsIndex);
        int ClassGetParent(int clsIndex);
        string[] ClassGetSourceFiles(int clsIndex);
        bool ClassIsAbstract(int clsIndex);
        bool ClassIsArray(int clsIndex);
        bool ClassIsInterface(int clsIndex);
        bool ClassIsPointer(int clsIndex);
        bool ClassIsPrimitive(int clsIndex);
        bool ClassIsPublic(int clsIndex);
        bool ClassIsReference(int clsIndex);
        bool ClassIsTypeVar(int clsIndex);
        bool ClassIsValueType(int clsIndex);
        bool ClassIsWith(int clsIndex);
        int FieldDeclaringClass(int fieldIndex);
        string FieldGetName(int fieldIndex);
        int FieldGetType(int fieldIndex);
        bool FieldIsFinal(int fieldIndex);
        bool FieldIsProtected(int fieldIndex);
        bool FieldIsPublic(int fieldIndex);
        bool FieldIsStatic(int fieldIndex);
        int FindClass(int asmIndex, string clsName, string pkgName);
        int FindImage(string imagePath);
        string GetPdbPath(int asmIndex);
        int[] ImageAllClasses(int asmIndex);
        string ImageGetAssemblyName(int index);
        string[] ImageGetRefrencedAssamblies(int asmIndex);
        byte[] MethodGetBytecode(int methodIndex);
        int[] MethodGetCustomAttributes(int methodIndex);
        int MethodGetDeclaringClass(int methodIndex);
        ExceptionEntry[] MethodGetHandlers(int methodIndex);
        int MethodGetHeaderSize(int methodIndex);
        ulong MethodGetLineNumber(int methodIndex, ulong offset);
        int MethodGetLocalVariableType(int methodIndex, int localIndex);
        int MethodGetMaxLocals(int index);
        int MethodGetMaxStackHeight(int index);
        string MethodGetName(int methodIndex);
        int MethodGetNumberOfParameters(int methodIndex);
        int MethodGetParameterType(int methodIndex, int paramIndex);
        int MethodGetReturnType(int methodIndex);
        string MethodGetSourceFileName(int methodIndex, ulong offset);
        bool MethodIsAbstract(int methodIndex);
        bool MethodIsFinal(int methodIndex);
        bool MethodIsInit(int methodIndex);
        bool MethodIsNative(int index);
        bool MethodIsPrivate(int methodIndex);
        bool MethodIsPublic(int methodIndex);
        bool MethodIsStatic(int methodIndex);
        int MethodGetAccessMask(int methodIndex);
        int NumberOfClasses(int index);
        int PointerGetReferrent(int clsIndex);
        string PrimitiveGetName(int index);
        int RefGetReferrent(int clsIndex);
        int ResolveFieldToken(int methodIndex, int token);
        int ResolveMethodToken(int methodIndex, int token);
        string ResolveStringToken(int methodIndex, int token);
        int ResolveTypeToken(int methodIndex, int token);
        int WithGetBase(int index);
        int WithGetNumParams(int clsIndex);
        int WithGetParam(int clsIndex, int paramIndex);
       	int MethodNumberOfOutParameters(int index);

    }
}
